/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stub;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.BlockingQueueFactory;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.stub.StubEndpoint;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.NormalizedUri;

@org.apache.camel.spi.annotations.Component(value="stub")
public class StubComponent
extends SedaComponent {
    @Metadata
    private boolean shadow;
    @Metadata
    private String shadowPattern;

    @Override
    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
    }

    @Override
    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
    }

    @Override
    protected StubEndpoint createEndpoint(String endpointUri, Component component, BlockingQueueFactory<Exchange> queueFactory, int concurrentConsumers) {
        return new StubEndpoint(endpointUri, component, queueFactory, concurrentConsumers);
    }

    @Override
    protected StubEndpoint createEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        return new StubEndpoint(endpointUri, component, queue, concurrentConsumers);
    }

    protected String resolveShadowUri(String uri) {
        if (uri.startsWith("stub://")) {
            uri = uri.substring(7);
        } else if (uri.startsWith("stub:")) {
            uri = uri.substring(5);
        }
        return uri;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public String getShadowPattern() {
        return this.shadowPattern;
    }

    public void setShadowPattern(String shadowPattern) {
        this.shadowPattern = shadowPattern;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.shadow) {
            EndpointRegistry registry = this.getCamelContext().getEndpointRegistry();
            this.getCamelContext().getCamelContextExtension().registerEndpointCallback((uri, endpoint) -> {
                String shadowUri;
                boolean match;
                boolean bl = match = this.shadowPattern == null || EndpointHelper.matchEndpoint(this.getCamelContext(), uri, this.shadowPattern);
                if (match && !uri.equals(shadowUri = this.resolveShadowUri(uri))) {
                    NormalizedUri nuri = NormalizedUri.newNormalizedUri(shadowUri, false);
                    registry.put(nuri, endpoint);
                }
                return endpoint;
            });
        }
    }
}

