/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuDefaultComponent;
import org.apache.camel.component.tahu.TahuHostEndpoint;
import org.apache.camel.spi.annotations.Component;

@Component(value="tahu-host")
public class TahuHostComponent
extends TahuDefaultComponent {
    public TahuHostComponent() {
    }

    public TahuHostComponent(CamelContext context) {
        super(context);
    }

    public TahuHostComponent(TahuConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected TahuHostEndpoint doCreateEndpoint(String uri, List<String> descriptorSegments, TahuConfiguration tahuConfig) throws Exception {
        String hostId = descriptorSegments.get(0);
        return new TahuHostEndpoint(uri, this, tahuConfig, hostId);
    }

    public final TahuHostEndpoint createHostAppEndpoint(String hostId) throws Exception {
        String uri = "tahu-host:" + hostId;
        TahuHostEndpoint endpoint = (TahuHostEndpoint)this.createEndpoint(uri, hostId, Map.of());
        return endpoint;
    }
}

