/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.edge.api.MetricHandler;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.message.SparkplugBPayloadEncoder;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;
import org.eclipse.tahu.message.model.StatePayload;
import org.eclipse.tahu.message.model.Topic;
import org.eclipse.tahu.model.MetricMap;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.ClientCallback;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.RandomStartupDelay;
import org.eclipse.tahu.mqtt.TahuClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeClient
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger((String)EdgeClient.class.getName());
    private final List<MqttServerDefinition> mqttServerDefinitions;
    private final ClientCallback callback;
    private final MetricHandler metricHandler;
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final Map<String, Boolean> deviceStatusMap;
    private final String primaryHostId;
    private final MetricMap metricMap;
    private final long rebirthDebounceDelay;
    private final RandomStartupDelay randomStartupDelay;
    private TahuClient tahuClient;
    private final Object clientLock = new Object();
    private int seq;
    private int currentMqttClientIndex;
    private volatile boolean stayRunning;
    private boolean connectedToPrimaryHost;
    private Long lastStatePayloadTimestamp;
    private Timer primaryHostIdResponseTimer;
    private Timer rebirthDelayTimer;

    public EdgeClient(MetricHandler metricHandler, EdgeNodeDescriptor edgeNodeDescriptor, List<String> deviceIds, String primaryHostId, boolean useAliases, Long rebirthDebounceDelay, List<MqttServerDefinition> mqttServerDefinitions, ClientCallback callback, RandomStartupDelay randomStartupDelay) {
        this.mqttServerDefinitions = mqttServerDefinitions;
        this.callback = callback;
        this.metricHandler = metricHandler;
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.deviceStatusMap = new ConcurrentHashMap<String, Boolean>();
        if (deviceIds != null) {
            for (String deviceId : deviceIds) {
                this.deviceStatusMap.put(deviceId, new Boolean(false));
            }
        }
        this.primaryHostId = primaryHostId;
        this.metricMap = useAliases ? new MetricMap() : null;
        this.rebirthDebounceDelay = rebirthDebounceDelay;
        this.randomStartupDelay = randomStartupDelay;
        this.stayRunning = true;
        this.connectedToPrimaryHost = false;
        this.currentMqttClientIndex = -1;
    }

    public void shutdown() {
        this.disconnect(true);
        this.stayRunning = false;
        this.connectedToPrimaryHost = false;
    }

    public boolean isDisconnectedOrDisconnecting() {
        return this.tahuClient.isDisconnectInProgress() || !this.tahuClient.isConnected();
    }

    public boolean isConnected() {
        return this.tahuClient != null && this.tahuClient.isConnected();
    }

    public boolean isConnectedToPrimaryHost() {
        return this.connectedToPrimaryHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean publishLwt) {
        Object object = this.clientLock;
        synchronized (object) {
            logger.debug("{} Attempting to disconnect from target server", (Object)this.mqttServerDefinitions.get(this.currentMqttClientIndex).getMqttClientId());
            if (this.primaryHostIdResponseTimer != null) {
                logger.debug("Cancelling the primary host ID timer");
                this.primaryHostIdResponseTimer.cancel();
                this.primaryHostIdResponseTimer = null;
            }
            this.connectedToPrimaryHost = false;
            if (this.tahuClient != null) {
                String connectionId = this.tahuClient.getMqttServerUrl() + " :: " + this.tahuClient.getClientId();
                logger.info("Attempting disconnect {}", (Object)connectionId);
                try {
                    if (publishLwt) {
                        for (String deviceId : this.deviceStatusMap.keySet()) {
                            this.publishDeviceDeath(deviceId);
                        }
                        this.tahuClient.disconnect(50L, 50L, true, true, false);
                    } else {
                        this.tahuClient.disconnect(0L, 1L, false, false, false);
                    }
                    logger.info("Successfully disconnected {}", (Object)connectionId);
                }
                catch (Throwable t) {
                    logger.error("Error while attempting to close client: {}", (Object)connectionId, (Object)t);
                }
            }
        }
    }

    public void publishNodeBirth(SparkplugBPayloadMap payload) throws SparkplugInvalidTypeException {
        if (this.metricMap != null) {
            this.metricMap.clear();
            for (Metric metric : payload.getMetrics()) {
                metric.setAlias(this.metricMap.addGeneratedAlias(metric.getName(), metric.getDataType()));
            }
        }
        if (payload.getMetric("Node Control/Rebirth") == null) {
            payload.addMetric(new Metric.MetricBuilder("Node Control/Rebirth", MetricDataType.Boolean, (Object)false).createMetric());
        }
        this.publishSparkplugMessage(new Topic("spBv1.0", this.edgeNodeDescriptor, MessageType.NBIRTH), payload, 0, false);
    }

    public void publishNodeData(SparkplugBPayload payload) {
        if (this.connectedToPrimaryHost) {
            if (this.metricMap != null) {
                for (Metric metric : payload.getMetrics()) {
                    metric.setAlias(this.metricMap.getAlias(metric.getName()));
                    metric.setName(null);
                }
            }
            this.publishSparkplugMessage(new Topic("spBv1.0", this.edgeNodeDescriptor, MessageType.NDATA), payload, 0, false);
        }
    }

    public void publishDeviceBirth(String deviceId, SparkplugBPayload payload) {
        if (this.metricMap != null) {
            for (Metric metric : payload.getMetrics()) {
                metric.setAlias(this.metricMap.addGeneratedAlias(metric.getName(), metric.getDataType()));
            }
        }
        this.publishSparkplugMessage(new Topic("spBv1.0", new DeviceDescriptor(this.edgeNodeDescriptor, deviceId), MessageType.DBIRTH), payload, 0, false);
        this.deviceStatusMap.put(deviceId, new Boolean(true));
    }

    public void publishDeviceData(String deviceId, SparkplugBPayload payload) {
        if (this.connectedToPrimaryHost) {
            if (this.metricMap != null && this.deviceStatusMap.get(deviceId) != null && this.deviceStatusMap.get(deviceId).booleanValue()) {
                for (Metric metric : payload.getMetrics()) {
                    metric.setAlias(this.metricMap.getAlias(metric.getName()));
                    metric.setName(null);
                }
            }
            this.publishSparkplugMessage(new Topic("spBv1.0", new DeviceDescriptor(this.edgeNodeDescriptor, deviceId), MessageType.DDATA), payload, 0, false);
        }
    }

    public void publishDeviceDeath(String deviceId) {
        SparkplugBPayloadMap.SparkplugBPayloadMapBuilder payloadBuilder = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder();
        payloadBuilder.setTimestamp(new Date());
        this.publishSparkplugMessage(new Topic("spBv1.0", new DeviceDescriptor(this.edgeNodeDescriptor, deviceId), MessageType.DDEATH), payloadBuilder.createPayload(), 0, false);
        this.deviceStatusMap.put(deviceId, new Boolean(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSparkplugMessage(Topic topic, SparkplugBPayload payload, int qos, boolean retained) {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                payload.setSeq(this.getNextSeqNum());
                if (topic.isType(MessageType.DCMD) || topic.isType(MessageType.DDATA) || topic.isType(MessageType.NCMD) || topic.isType(MessageType.NDATA)) {
                    this.tahuClient.publish(topic.toString(), new SparkplugBPayloadEncoder().getBytes(payload, true), qos, retained);
                } else {
                    this.tahuClient.publish(topic.toString(), new SparkplugBPayloadEncoder().getBytes(payload, false), qos, retained);
                }
            }
            catch (Exception e) {
                logger.error("Failed to publish message on topic={}", (Object)topic, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSeqNum() {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.seq == 256) {
                this.seq = 0;
            }
            logger.trace("INC: SEQ number is: {}", (Object)this.seq);
            return this.seq++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Running EdgeClient: {}", (Object)this.edgeNodeDescriptor);
        while (this.stayRunning) {
            Object object = this.clientLock;
            synchronized (object) {
                try {
                    boolean tryToConnect = false;
                    boolean transitionToOnline = false;
                    if (this.tahuClient == null || !this.tahuClient.isConnected()) {
                        if (!this.stayRunning) {
                            return;
                        }
                        logger.warn("{} Not connected - attempting connect with isStayRunning={}", (Object)this.edgeNodeDescriptor, (Object)this.stayRunning);
                        tryToConnect = true;
                    }
                    if (this.stayRunning && tryToConnect) {
                        boolean connectedToServer = this.connectToTargetServer();
                        if (connectedToServer) {
                            try {
                                int[] grantedQos;
                                transitionToOnline = true;
                                ArrayList<String> subTopics = new ArrayList<String>();
                                ArrayList<Integer> subQos = new ArrayList<Integer>();
                                subTopics.add("spBv1.0/" + this.edgeNodeDescriptor.getGroupId() + "/NCMD/" + this.edgeNodeDescriptor.getEdgeNodeId());
                                subQos.add(1);
                                if (this.deviceStatusMap != null && !this.deviceStatusMap.isEmpty()) {
                                    for (String deviceId : this.deviceStatusMap.keySet()) {
                                        subTopics.add("spBv1.0/" + this.edgeNodeDescriptor.getGroupId() + "/DCMD/" + this.edgeNodeDescriptor.getEdgeNodeId() + "/" + deviceId);
                                        subQos.add(1);
                                    }
                                }
                                subTopics.add("spBv1.0/" + this.edgeNodeDescriptor.getGroupId() + "/NDEATH/" + this.edgeNodeDescriptor.getEdgeNodeId());
                                subQos.add(1);
                                if (this.primaryHostId != null && !this.primaryHostId.isEmpty()) {
                                    subTopics.add("spBv1.0/STATE/" + this.primaryHostId);
                                    subQos.add(1);
                                }
                                if ((grantedQos = this.tahuClient.subscribe(subTopics.toArray(new String[0]), subQos.stream().mapToInt(i -> i).toArray())) == null || grantedQos.length == 0) {
                                    logger.error("Failed to subscribe to: {}", subTopics);
                                    transitionToOnline = false;
                                    this.disconnect(true);
                                }
                            }
                            catch (TahuException e) {
                                logger.error("Failed to subscribe to TARGET elements", (Throwable)e);
                                connectedToServer = false;
                                transitionToOnline = false;
                            }
                        } else {
                            this.disconnect(true);
                        }
                    }
                    if (transitionToOnline) {
                        transitionToOnline = false;
                        if (this.primaryHostId != null && !this.primaryHostId.isEmpty()) {
                            logger.info("Waiting for primary host {} to be online", (Object)this.primaryHostId);
                            this.connectedToPrimaryHost = false;
                            if (this.primaryHostIdResponseTimer != null) {
                                this.primaryHostIdResponseTimer.cancel();
                                this.primaryHostIdResponseTimer = null;
                            }
                            this.primaryHostIdResponseTimer = new Timer(String.format("PrimaryHostIdResponseTimer-%s", this.edgeNodeDescriptor.toString()));
                            this.primaryHostIdResponseTimer.schedule((TimerTask)new PrimaryHostIdResponseTask(), 30000L);
                            String subHostTopic = "spBv1.0/" + this.primaryHostId;
                            int grantedQos = this.tahuClient.subscribe(subHostTopic, 1);
                            if (grantedQos != 1) {
                                logger.error("Failed to subscribe to '{}'", (Object)subHostTopic);
                                if (this.primaryHostIdResponseTimer != null) {
                                    this.primaryHostIdResponseTimer.cancel();
                                    this.primaryHostIdResponseTimer = null;
                                }
                                this.disconnect(true);
                            }
                        } else {
                            this.handleOnlineTransition("MAIN THREAD");
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Stay Running Exception", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToTargetServer() {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.tahuClient != null && this.tahuClient.isConnected()) {
                logger.debug("Not connecting to server, client is already connected");
                return false;
            }
            MqttClientId mqttClientId = null;
            try {
                Topic deathTopic = this.metricHandler.getDeathTopic();
                byte[] deathPayloadBytes = null;
                try {
                    deathPayloadBytes = this.metricHandler.getDeathPayloadBytes();
                }
                catch (TahuException te) {
                    logger.error("Failed to get the NDEATH message deathTopic={} - disconnecting and BAILING", (Object)deathTopic);
                    this.stayRunning = false;
                    this.disconnect(true);
                    return false;
                }
                if (deathTopic == null || deathPayloadBytes == null) {
                    logger.error("Failed to get the NDEATH message deathTopic={} and deathPayloadBytes={}", (Object)deathTopic, (Object)deathPayloadBytes);
                    return false;
                }
                ++this.currentMqttClientIndex;
                if (this.currentMqttClientIndex >= this.mqttServerDefinitions.size()) {
                    this.currentMqttClientIndex = 0;
                }
                MqttServerDefinition mqttServerDefinition = this.mqttServerDefinitions.get(this.currentMqttClientIndex);
                mqttClientId = mqttServerDefinition.getMqttClientId();
                this.tahuClient = new TahuClient(mqttClientId, mqttServerDefinition.getMqttServerName(), mqttServerDefinition.getMqttServerUrl(), mqttServerDefinition.getUsername(), mqttServerDefinition.getPassword(), true, mqttServerDefinition.getKeepAliveTimeout(), this.callback, this.randomStartupDelay, true, false, null, null, false, deathTopic.toString(), deathPayloadBytes, 1, false);
                this.tahuClient.setTrackFirstConnection(true);
                this.tahuClient.setAutoReconnect(false);
                logger.info("{} Attempting to connect", (Object)mqttClientId);
                this.tahuClient.connect();
                int totalTimeout = (int)((double)this.tahuClient.getKeepAlive() * 1.5 + (double)((int)this.rebirthDebounceDelay / 1000));
                logger.debug("Total timeout to connect is {} seconds", (Object)totalTimeout);
                for (int i = 0; i < totalTimeout; ++i) {
                    if (this.tahuClient.isAttemptingConnect()) {
                        logger.info("{} is attempting to connect", (Object)mqttClientId);
                    } else {
                        logger.info("{} is not attempting to connect", (Object)mqttClientId);
                    }
                    if (!this.stayRunning) {
                        logger.debug("{} Shutting down", (Object)mqttServerDefinition.getMqttClientId());
                        this.disconnect(true);
                        return false;
                    }
                    if (this.tahuClient.isAttemptingConnect()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            logger.error("Error occured while sleeping", (Throwable)e);
                        }
                        continue;
                    }
                    if (this.tahuClient.isConnected()) {
                        logger.info("{} Connected to the MQTT Server", (Object)mqttClientId);
                        return true;
                    }
                    logger.info("{} No longer attempting to connect", (Object)mqttClientId);
                    break;
                }
                logger.error("{} Failed to achieve connected state", (Object)mqttClientId);
                this.disconnect(true);
                return false;
            }
            catch (Throwable t) {
                logger.error("{} Error while attempting to connect to target server for {}", new Object[]{mqttClientId, this.edgeNodeDescriptor, t});
                logger.info("\ttahuClient: {}", (Object)this.tahuClient);
                this.disconnect(true);
                return false;
            }
        }
    }

    private void handleOnlineTransition(String source) {
        if (!this.stayRunning) {
            logger.debug("EdgeClient is shutting down - not publishing BIRTH messages");
            this.disconnect(true);
            return;
        }
        logger.info("[{}] Handling transition to online", (Object)source);
        try {
            logger.debug("Publishing BIRTH for {}", (Object)this.edgeNodeDescriptor);
            this.seq = 0;
            this.metricHandler.publishBirthSequence();
        }
        catch (Exception e) {
            logger.error("Failed to publish birth - BAILING", (Throwable)e);
            this.stayRunning = false;
            this.disconnect(true);
            return;
        }
        this.connectedToPrimaryHost = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStateMessage(String primaryHostId, StatePayload statePayload) {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.primaryHostId != null && this.primaryHostId.equals(primaryHostId)) {
                Long payloadTimestamp = statePayload.getTimestamp();
                if (this.lastStatePayloadTimestamp != null && payloadTimestamp.compareTo(this.lastStatePayloadTimestamp) < 0) {
                    logger.info("Reveived a stale STATE message - ignoring hostId={} and payload={}", (Object)primaryHostId, (Object)statePayload);
                    return;
                }
                this.lastStatePayloadTimestamp = payloadTimestamp;
                if (statePayload.isOnline().booleanValue() && !this.connectedToPrimaryHost) {
                    logger.info("Critical/Primary app is online - cancelling disconnect timer");
                    if (this.primaryHostIdResponseTimer != null) {
                        this.primaryHostIdResponseTimer.cancel();
                        this.primaryHostIdResponseTimer = null;
                    }
                    this.handleOnlineTransition("STATE CHANGE");
                } else if (!statePayload.isOnline().booleanValue()) {
                    logger.error("Critical/Primary app went offline - disconnecting from this server");
                    if (this.connectedToPrimaryHost) {
                        this.connectedToPrimaryHost = false;
                        this.disconnect(true);
                    } else {
                        this.disconnect(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRebirthRequest(boolean isRebirth) {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.tahuClient == null) {
                logger.warn("Not processing {} request, client is null", (Object)(isRebirth ? "Rebirth" : "Birth"));
            } else if (!this.stayRunning) {
                logger.warn("Not processing {} request, client is shutting down", (Object)(isRebirth ? "Rebirth" : "Birth"));
            } else if (this.rebirthDelayTimer == null) {
                logger.info("Processing {} request", (Object)(isRebirth ? "Rebirth" : "Birth"));
                this.seq = 0;
                this.metricHandler.publishBirthSequence();
                long randomDelay = this.randomStartupDelay != null ? this.randomStartupDelay.getRandomDelay() : 0L;
                this.rebirthDelayTimer = new Timer(String.format("RebirthDelayTimer-%s", this.edgeNodeDescriptor.toString()));
                logger.debug("Setting RebirthDelayTimer to {}ms", (Object)(randomDelay + this.rebirthDebounceDelay));
                this.rebirthDelayTimer.schedule((TimerTask)new RebirthDelayTask(), randomDelay + this.rebirthDebounceDelay);
            } else {
                logger.info("Rebirth request but just issued a rebirth - ignoring");
            }
        }
    }

    private class RebirthDelayTask
    extends TimerTask {
        private RebirthDelayTask() {
        }

        @Override
        public void run() {
            EdgeClient.this.rebirthDelayTimer.cancel();
            EdgeClient.this.rebirthDelayTimer = null;
        }
    }

    private class PrimaryHostIdResponseTask
    extends TimerTask {
        private PrimaryHostIdResponseTask() {
        }

        @Override
        public void run() {
            logger.error("Failed to validate the Primary Host is online");
            EdgeClient.this.disconnect(true);
        }
    }
}

