/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuDefaultEndpoint;
import org.apache.camel.component.tahu.handlers.TahuHostApplication;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TahuHostConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(TahuHostConsumer.class);
    private static final ConcurrentMap<String, TahuHostApplication> hostHandlers = new ConcurrentHashMap<String, TahuHostApplication>();
    private final TahuDefaultEndpoint endpoint;
    private final TahuHostApplication tahuHostApplication;
    private final Marker loggingMarker;
    private static final List<MessageType> HANDLED_MESSAGE_TYPES = List.of(MessageType.NBIRTH, MessageType.NDATA, MessageType.NDEATH, MessageType.DBIRTH, MessageType.DDATA, MessageType.DDEATH);

    TahuHostConsumer(TahuDefaultEndpoint endpoint, Processor processor, String hostId) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.loggingMarker = MarkerFactory.getMarker((String)hostId);
        TahuConfiguration configuration = endpoint.getConfiguration();
        this.tahuHostApplication = hostHandlers.computeIfAbsent(hostId, hId -> {
            List<MqttServerDefinition> serverDefinitions = configuration.getServerDefinitionList();
            TahuHostApplication thah = new TahuHostApplication.HostApplicationBuilder().hostId((String)hId).serverDefinitions(serverDefinitions).onMessageConsumer(this::onMessageConsumer).onMetricConsumer(this::onMetricConsumer).build();
            return thah;
        });
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.tahuHostApplication.startup();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.tahuHostApplication.shutdown();
    }

    /*
     * Exception decompiling
     */
    void onMessageConsumer(EdgeNodeDescriptor edgeNodeDescriptor, org.eclipse.tahu.message.model.Message tahuMessage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanExpression.applyExpressionRewriter(BooleanExpression.java:63)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NotOperation.applyExpressionRewriter(NotOperation.java:55)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.rewriteExpressions(StructuredIf.java:170)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMetricConsumer(EdgeNodeDescriptor edgeNodeDescriptor, Metric metric) {
        Exchange exchange = null;
        try {
            exchange = this.createExchange(true);
            CamelContext context = exchange.getContext();
            Message camelMessage = ObjectHelper.supplyIfEmpty(exchange.getMessage(), () -> new DefaultMessage(context));
            exchange.setMessage(camelMessage);
            camelMessage.setHeader("CamelTahuEdgeNodeDescriptor", edgeNodeDescriptor.getDescriptorString());
            camelMessage.setHeader("CamelTahuMetric." + metric.getName(), metric);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.debug(this.loggingMarker, "Exception caught processing exchange from Sparkplug Metric", (Throwable)e);
            if (exchange != null) {
                exchange.setException(e);
            }
        }
        finally {
            if (exchange != null && exchange.getException() != null) {
                this.getExceptionHandler().handleException("Exception caught processing exchange from Sparkplug Metric", exchange, exchange.getException());
            }
        }
    }

    private static /* synthetic */ Object lambda$onMessageConsumer$4(Object[] arr) {
        return arr[1];
    }

    private static /* synthetic */ String lambda$onMessageConsumer$3(Object[] arr) {
        return (String)arr[0];
    }
}

