/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.FileUtils;
import org.eclipse.tahu.message.BdSeqManager;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class CamelBdSeqManager
implements BdSeqManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelBdSeqManager.class);
    private static final Charset bdSeqNumFileCharset = StandardCharsets.UTF_8;
    private final File bdSeqNumFile;
    private final Marker loggingMarker;

    public CamelBdSeqManager(EdgeNodeDescriptor edgeNodeDescriptor, String bdSeqNumPath) {
        this.loggingMarker = MarkerFactory.getMarker((String)edgeNodeDescriptor.getDescriptorString());
        if (ObjectHelper.isEmpty((String)bdSeqNumPath)) {
            bdSeqNumPath = FileUtils.getTempDirectoryPath() + File.separator + "CamelTahuTemp";
        }
        String bdSeqNumFileName = (String)bdSeqNumPath + File.separator + edgeNodeDescriptor.getDescriptorString() + "-bdSeqNum";
        this.bdSeqNumFile = new File(bdSeqNumFileName);
    }

    @Override
    public long getNextDeathBdSeqNum() {
        try {
            long bdSeqNum = 0L;
            if (this.bdSeqNumFile.exists() && FileUtils.sizeOf(this.bdSeqNumFile) > 0L) {
                String bdSeqFileContents = FileUtils.readFileToString(this.bdSeqNumFile, bdSeqNumFileCharset);
                bdSeqNum = this.normalizeBdSeq(Long.parseLong(bdSeqFileContents));
                LOG.debug(this.loggingMarker, "Next Death bdSeq number: {}", (Object)bdSeqNum);
            }
            return bdSeqNum;
        }
        catch (Exception e) {
            LOG.warn(this.loggingMarker, "Failed to get the bdSeq number from the persistent directory", (Throwable)e);
            this.storeNextDeathBdSeqNum(0L);
            return 0L;
        }
    }

    @Override
    public void storeNextDeathBdSeqNum(long bdSeqNum) {
        try {
            String bdSeqFileContents = Long.toString(this.normalizeBdSeq(bdSeqNum));
            FileUtils.writeStringToFile(this.bdSeqNumFile, bdSeqFileContents, bdSeqNumFileCharset, false);
        }
        catch (Exception e) {
            LOG.error(this.loggingMarker, "Failed to write the bdSeq number to the persistent directory", (Throwable)e);
        }
    }

    private long normalizeBdSeq(long bdSeqNum) {
        return bdSeqNum & 0xFFL;
    }
}

