/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.manager;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.host.model.HostMetric;
import org.eclipse.tahu.message.model.SparkplugDescriptor;

public abstract class MetricManager {
    private final Map<String, HostMetric> metricMap = new ConcurrentHashMap<String, HostMetric>();

    public abstract SparkplugDescriptor getSparkplugDescriptor();

    public Map<String, HostMetric> getMetricMap() {
        return Collections.unmodifiableMap(this.metricMap);
    }

    public Set<String> getMetricNames() {
        return this.metricMap.keySet();
    }

    public HostMetric getMetric(String metricName) {
        return this.metricMap.get(metricName);
    }

    public void putMetric(String metricName, HostMetric metric) {
        this.metricMap.put(metricName, metric);
    }

    public void updateValue(String metricName, Object value) {
        HostMetric hostMetric = this.metricMap.get(metricName);
        if (hostMetric != null) {
            hostMetric.setValue(value);
        }
    }

    public void setStale(String metricName, boolean stale) {
        HostMetric hostMetric = this.metricMap.get(metricName);
        if (hostMetric != null) {
            hostMetric.setStale(stale);
        }
    }

    public void clearMetrics() {
        this.metricMap.clear();
    }
}

