/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.mqtt;

import java.util.UUID;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;

public class MqttClientId {
    private static final int MAX_CLIENT_ID_LENGTH = 23;
    private String mqttClientId;

    public MqttClientId(String mqttClientId, boolean checkClientIdLength) throws TahuException {
        if (mqttClientId == null) {
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "MQTT Client ID is not set");
        }
        if (checkClientIdLength && mqttClientId.length() > 23) {
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "MQTT Client ID can not exceed 23 characters in length");
        }
        this.mqttClientId = mqttClientId;
    }

    public static String generate(String clientIdPrefix) throws TahuException {
        if (clientIdPrefix != null && clientIdPrefix.length() > 21) {
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "MQTT Client ID prefix can not exceed 21 characters in length");
        }
        return clientIdPrefix + "-" + UUID.randomUUID().toString().substring(0, 23 - (clientIdPrefix != null ? clientIdPrefix.length() : 0) - 1);
    }

    public String getMqttClientId() {
        return this.mqttClientId;
    }

    public String toString() {
        return this.mqttClientId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mqttClientId == null ? 0 : this.mqttClientId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MqttClientId other = (MqttClientId)obj;
        return !(this.mqttClientId == null ? other.mqttClientId != null : !this.mqttClientId.equals(other.mqttClientId));
    }
}

