/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ObjectHelper;

public final class GenericFileDefaultSorter {
    private GenericFileDefaultSorter() {
    }

    public static Comparator<Exchange> sortByFileLanguage(CamelContext context, String expression, boolean reverse) {
        return GenericFileDefaultSorter.sortByFileLanguage(context, expression, reverse, false, null);
    }

    public static Comparator<Exchange> sortByFileLanguage(CamelContext context, String expression, boolean reverse, boolean ignoreCase) {
        return GenericFileDefaultSorter.sortByFileLanguage(context, expression, reverse, ignoreCase, null);
    }

    public static Comparator<Exchange> sortByFileLanguage(CamelContext context, final String expression, final boolean reverse, final boolean ignoreCase, final Comparator<Exchange> nested) {
        Object text = expression;
        if (!expression.startsWith("${")) {
            text = "${" + (String)text;
        }
        if (!expression.endsWith("}")) {
            text = (String)text + "}";
        }
        Language language = context.resolveLanguage("file");
        final Expression exp = language.createExpression((String)text);
        return new Comparator<Exchange>(){

            @Override
            public int compare(Exchange o1, Exchange o2) {
                Object result2;
                Object result1 = exp.evaluate(o1, Object.class);
                int answer = ObjectHelper.compare(result1, result2 = exp.evaluate(o2, Object.class), ignoreCase);
                if (answer == 0 && nested != null) {
                    answer = nested.compare(o1, o2);
                }
                return reverse ? -1 * answer : answer;
            }

            public String toString() {
                return expression + (String)(nested != null ? ";" + nested.toString() : "");
            }
        };
    }
}

