/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tarfile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.tarfile.TarIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@Dataformat(value="tarFile")
public class TarFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final long DEFAULT_MAXIMUM_DECOMPRESSED_SIZE = 0x40000000L;
    private boolean usingIterator;
    private boolean allowEmptyDirectory;
    private boolean preservePathElements;
    private long maxDecompressedSize = 0x40000000L;

    @Override
    public String getDataFormatName() {
        return "tarFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filepath = exchange.getIn().getHeader("CamelFileName", String.class);
        Long filelength = exchange.getIn().getHeader("CamelFileLength", Long.class);
        String filename = filepath == null ? (filepath = StringHelper.sanitize(exchange.getIn().getMessageId())) : Paths.get(filepath, new String[0]).getFileName().toString();
        TarArchiveOutputStream tos = new TarArchiveOutputStream(stream);
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        if (filelength == null) {
            filelength = is.available();
        }
        if (this.preservePathElements) {
            this.createTarEntries(tos, filepath, filelength);
        } else {
            this.createTarEntries(tos, filename, filelength);
        }
        try {
            IOHelper.copy(is, tos);
        }
        catch (Throwable throwable) {
            tos.closeArchiveEntry();
            IOHelper.close(is, tos);
            throw throwable;
        }
        tos.closeArchiveEntry();
        IOHelper.close(is, tos);
        String newFilename = filename + ".tar";
        exchange.getMessage().setHeader("CamelFileName", newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Object object;
        if (this.usingIterator) {
            TarIterator tarIterator = new TarIterator(exchange, stream);
            tarIterator.setAllowEmptyDirectory(this.allowEmptyDirectory);
            return tarIterator;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        TarArchiveInputStream tis = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", bis);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        try {
            TarArchiveEntry entry = tis.getNextEntry();
            if (entry == null) {
                throw new IllegalStateException("Unable to untar the file, it may be corrupted.");
            }
            exchange.getMessage().setHeader("CamelFileName", entry.getName());
            IOHelper.copy(tis, osb, 16384, false, this.maxDecompressedSize);
            entry = tis.getNextEntry();
            if (entry != null) {
                throw new IllegalStateException("Tar file has more than 1 entry.");
            }
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close(osb, tis, bis);
            throw throwable;
        }
        IOHelper.close(osb, tis, bis);
        return object;
    }

    private void createTarEntries(TarArchiveOutputStream tos, String filepath, Long filelength) throws IOException {
        Iterator<Path> elements = Paths.get(filepath, new String[0]).iterator();
        StringBuilder sb = new StringBuilder(256);
        while (elements.hasNext()) {
            Path path = elements.next();
            Object element = path.toString();
            Long length = filelength;
            if (elements.hasNext()) {
                element = (String)element + "/";
                length = 0L;
            }
            TarArchiveEntry entry = new TarArchiveEntry(String.valueOf(sb) + (String)element);
            entry.setSize(length);
            tos.putArchiveEntry(entry);
            sb.append((String)element);
        }
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public boolean isAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    public boolean isPreservePathElements() {
        return this.preservePathElements;
    }

    public void setPreservePathElements(boolean preservePathElements) {
        this.preservePathElements = preservePathElements;
    }

    public long getMaxDecompressedSize() {
        return this.maxDecompressedSize;
    }

    public void setMaxDecompressedSize(long maxDecompressedSize) {
        this.maxDecompressedSize = maxDecompressedSize;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

