/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Processor;
import org.apache.camel.RoutingSlip;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@JdkService(value="annotation-processor-factory")
public final class DefaultAnnotationBasedProcessorFactory
implements AnnotationBasedProcessorFactory {
    @Override
    public AsyncProcessor createDynamicRouter(CamelContext camelContext, DynamicRouter annotation) {
        org.apache.camel.processor.DynamicRouter dynamicRouter = new org.apache.camel.processor.DynamicRouter(camelContext);
        dynamicRouter.setDelimiter(annotation.delimiter());
        dynamicRouter.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        dynamicRouter.setCacheSize(annotation.cacheSize());
        return dynamicRouter;
    }

    @Override
    public AsyncProcessor createRecipientList(CamelContext camelContext, org.apache.camel.RecipientList annotation) {
        ExecutorService executor;
        RecipientList recipientList = new RecipientList(camelContext, annotation.delimiter());
        recipientList.setStopOnException(annotation.stopOnException());
        recipientList.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        recipientList.setParallelProcessing(annotation.parallelProcessing());
        recipientList.setParallelAggregate(annotation.parallelAggregate());
        recipientList.setStreaming(annotation.streaming());
        recipientList.setTimeout(annotation.timeout());
        recipientList.setCacheSize(annotation.cacheSize());
        recipientList.setShareUnitOfWork(annotation.shareUnitOfWork());
        if (ObjectHelper.isNotEmpty(annotation.executorService())) {
            executor = camelContext.getExecutorServiceManager().newThreadPool((Object)this, "@RecipientList", annotation.executorService());
            recipientList.setExecutorService(executor);
        }
        if (annotation.parallelProcessing() && recipientList.getExecutorService() == null) {
            executor = camelContext.getExecutorServiceManager().newDefaultThreadPool(this, "@RecipientList");
            recipientList.setExecutorService(executor);
        }
        if (ObjectHelper.isNotEmpty(annotation.aggregationStrategy())) {
            AggregationStrategy strategy = CamelContextHelper.mandatoryLookup(camelContext, annotation.aggregationStrategy(), AggregationStrategy.class);
            recipientList.setAggregationStrategy(strategy);
        }
        if (ObjectHelper.isNotEmpty(annotation.onPrepare())) {
            Processor onPrepare = CamelContextHelper.mandatoryLookup(camelContext, annotation.onPrepare(), Processor.class);
            recipientList.setOnPrepare(onPrepare);
        }
        return recipientList;
    }

    @Override
    public AsyncProcessor createRoutingSlip(CamelContext camelContext, RoutingSlip annotation) {
        org.apache.camel.processor.RoutingSlip routingSlip = new org.apache.camel.processor.RoutingSlip(camelContext);
        routingSlip.setDelimiter(annotation.delimiter());
        routingSlip.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        routingSlip.setCacheSize(annotation.cacheSize());
        return routingSlip;
    }
}

