/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.function.BiPredicate;
import org.apache.camel.Ordered;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;

@FunctionalInterface
public interface LanguageCustomizer
extends Ordered {
    public static Builder<Language> builder() {
        return LanguageCustomizer.builder(Language.class);
    }

    public static <T extends Language> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static <T extends Language> LanguageCustomizer forType(Class<T> type, ThrowingConsumer<T, Exception> consumer) {
        return LanguageCustomizer.builder(type).build(consumer);
    }

    public void configure(String var1, Language var2);

    default public boolean isEnabled(String name, Language target) {
        return true;
    }

    @Override
    default public int getOrder() {
        return 0;
    }

    public static class Builder<T extends Language> {
        private final Class<T> type;
        private BiPredicate<String, Language> condition;
        private int order;

        public Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> withOrder(int order) {
            this.order = order;
            return this;
        }

        public Builder<T> withCondition(BiPredicate<String, Language> condition) {
            this.condition = condition;
            return this;
        }

        public LanguageCustomizer build(final ThrowingConsumer<T, Exception> consumer) {
            return this.build(new ThrowingBiConsumer<String, T, Exception>(){

                @Override
                public void accept(String name, T target) throws Exception {
                    consumer.accept(target);
                }
            });
        }

        public LanguageCustomizer build(final ThrowingBiConsumer<String, T, Exception> consumer) {
            final int order = this.order;
            final BiPredicate<String, Language> condition = this.condition != null ? this.condition : (name, target) -> true;
            return new LanguageCustomizer(){

                @Override
                public void configure(String name, Language target) {
                    ObjectHelper.notNull(name, "language name");
                    ObjectHelper.notNull(target, "language instance");
                    try {
                        consumer.accept(name, target);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public boolean isEnabled(String name, Language target) {
                    ObjectHelper.notNull(name, "language name");
                    ObjectHelper.notNull(target, "language instance");
                    return type.isAssignableFrom(target.getClass()) && condition.test(name, target);
                }

                @Override
                public int getOrder() {
                    return order;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Policy
    extends BiPredicate<String, Language> {
        public static Policy none() {
            return new Policy(){

                @Override
                public boolean test(String s, Language target) {
                    return false;
                }
            };
        }

        public static Policy any() {
            return new Policy(){

                @Override
                public boolean test(String s, Language target) {
                    return true;
                }
            };
        }
    }
}

