/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramConstants;
import org.apache.camel.component.telegram.TelegramConsumer;
import org.apache.camel.component.telegram.TelegramProducer;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.TelegramWebhookProcessor;
import org.apache.camel.component.telegram.service.TelegramServiceRestBotAPIAdapter;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="telegram", title="Telegram", syntax="telegram:type", category={Category.CLOUD, Category.API, Category.CHAT}, headersClass=TelegramConstants.class)
public class TelegramEndpoint
extends ScheduledPollEndpoint
implements WebhookCapableEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramEndpoint.class);
    @UriParam
    private TelegramConfiguration configuration;
    @UriParam(label="advanced")
    private HttpClient client;
    @UriParam(label="advanced", defaultValue="1048576")
    private int bufferSize = 0x100000;
    private WebhookConfiguration webhookConfiguration;
    private TelegramService telegramService;

    public TelegramEndpoint(String endpointUri, Component component, TelegramConfiguration configuration, HttpClient client) {
        super(endpointUri, component);
        this.configuration = configuration;
        this.client = client;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (this.configuration != null && ObjectHelper.isNotEmpty(this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty(this.configuration.getProxyPort())) {
                LOG.debug("Setup {} proxy host:{} port:{} for TelegramService", new Object[]{this.configuration.getProxyType(), this.configuration.getProxyHost(), this.configuration.getProxyPort()});
                builder.proxy(ProxySelector.of(new InetSocketAddress(this.configuration.getProxyHost(), (int)this.configuration.getProxyPort())));
            }
            this.client = builder.build();
        }
        if (this.telegramService == null) {
            this.telegramService = new TelegramServiceRestBotAPIAdapter(this.client, this.configuration.getBaseUri(), this.configuration.getAuthorizationToken(), this.bufferSize);
        }
    }

    @Override
    public Producer createProducer() throws Exception {
        return new TelegramProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        TelegramConsumer consumer = new TelegramConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public Processor createWebhookHandler(Processor next) {
        return new TelegramWebhookProcessor(next);
    }

    @Override
    public void registerWebhook() throws Exception {
        if (!this.telegramService.setWebhook(this.webhookConfiguration.computeFullExternalUrl())) {
            throw new RuntimeCamelException("The Telegram API refused to register a webhook");
        }
    }

    @Override
    public void unregisterWebhook() throws Exception {
        if (!this.telegramService.removeWebhook()) {
            throw new RuntimeCamelException("The Telegram API refused to unregister the webhook");
        }
    }

    public WebhookConfiguration getWebhookConfiguration() {
        return this.webhookConfiguration;
    }

    @Override
    public void setWebhookConfiguration(WebhookConfiguration webhookConfiguration) {
        this.webhookConfiguration = webhookConfiguration;
    }

    @Override
    public List<String> getWebhookMethods() {
        return Collections.singletonList("POST");
    }

    public TelegramConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TelegramConfiguration configuration) {
        this.configuration = configuration;
    }

    public TelegramService getTelegramService() {
        return this.telegramService;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

