/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.component.telegram.util.TelegramMessageHelper;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;

public class TelegramWebhookProcessor
extends AsyncProcessorSupport
implements AsyncProcessor {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private AsyncProcessor next;

    public TelegramWebhookProcessor(Processor next) {
        this.next = AsyncProcessorConverterHelper.convert(next);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Update update;
        try (InputStream source = exchange.getIn().getBody(InputStream.class);){
            update = MAPPER.readValue(source, Update.class);
        }
        catch (Exception ex) {
            exchange.setException(ex);
            callback.done(true);
            return true;
        }
        TelegramMessageHelper.populateExchange(exchange, update);
        return this.next.process(exchange, doneSync -> {
            exchange.getMessage().setBody("");
            callback.done(doneSync);
        });
    }
}

