/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixTimestampDeserializer
extends JsonDeserializer<Instant> {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            long unixTimestamp = Long.parseLong(jsonParser.getText());
            return Instant.ofEpochSecond(unixTimestamp);
        }
        catch (Exception e) {
            this.log.warn("Unable to deserialize the unix timestamp {}", (Object)jsonParser.getText(), (Object)e);
            return null;
        }
    }
}

