/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.telegram.model.MessageResult;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramAsyncHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramAsyncHandler.class);
    private final String uri;
    private final Class<? extends MessageResult> resultClass;
    private final ObjectMapper mapper;
    private final Exchange exchange;
    private final AsyncCallback callback;

    TelegramAsyncHandler(String uri, Class<? extends MessageResult> resultClass, ObjectMapper mapper, Exchange exchange, AsyncCallback callback) {
        this.uri = uri;
        this.resultClass = resultClass;
        this.mapper = mapper;
        this.exchange = exchange;
        this.callback = callback;
    }

    public static String extractCharset(String line, String defaultValue) {
        String charset;
        if (line == null) {
            return defaultValue;
        }
        String[] parts = line.split(" ");
        String charsetInfo = "";
        for (String part : parts) {
            if (!part.startsWith("charset")) continue;
            charsetInfo = part;
            break;
        }
        if ((charset = charsetInfo.replace("charset=", "").replace(";", "")).isBlank()) {
            return defaultValue;
        }
        return charset;
    }

    public Object handleCompressedResponse(HttpResponse<InputStream> response) {
        block21: {
            boolean success = response.statusCode() >= 200 && response.statusCode() < 300;
            String charsetInfo = response.headers().firstValue("Content-Type").orElse(null);
            String charset = TelegramAsyncHandler.extractCharset(charsetInfo, StandardCharsets.UTF_8.name());
            String contentEncoding = response.headers().firstValue("Content-Encoding").orElse(null);
            try (InputStream is = GZIPHelper.uncompressGzip(contentEncoding, response.body());
                 InputStreamReader r = new InputStreamReader(is, charset);){
                if (LOG.isDebugEnabled()) {
                    response.headers().map().forEach((key, value) -> LOG.debug("header {}={}", key, value));
                }
                if (success) {
                    MessageResult result;
                    if (LOG.isTraceEnabled()) {
                        String body = IOHelper.toString(r);
                        LOG.trace("Received body for {}: {}", (Object)this.uri, (Object)body);
                        result = this.mapper.readValue(body, this.resultClass);
                    } else {
                        result = this.mapper.readValue((Reader)r, this.resultClass);
                    }
                    this.exchange.getMessage().setBody(result);
                    break block21;
                }
                throw new RuntimeCamelException(this.uri + " responded: " + response.statusCode() + IOHelper.toString(r));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeCamelException("Could not parse the response from " + this.uri, ex);
            }
            finally {
                this.callback.done(false);
            }
        }
        return this.exchange;
    }
}

