/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramBodyPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramBodyPublisher.class);
    private final Set<TelegramBodyPart> bodyParts = new LinkedHashSet<TelegramBodyPart>();
    private final String boundary = RandomStringUtils.randomAlphanumeric(12);
    private final int bufferSize;

    public TelegramBodyPublisher(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void addBodyPart(TelegramBodyPart bodyPart) {
        this.bodyParts.add(bodyPart);
    }

    public HttpRequest.BodyPublisher newPublisher() {
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
        LOG.debug("Allocating {} bytes", (Object)this.bufferSize);
        TelegramBodyPublisher.serialize(this.bodyParts, buffer, this.boundary);
        int written = buffer.capacity() - buffer.remaining();
        return HttpRequest.BodyPublishers.ofByteArray(buffer.array(), 0, written);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void serialize(Set<TelegramBodyPart> bodyParts, ByteBuffer buffer, String separator) {
        try {
            boolean isMultiBody = false;
            for (TelegramBodyPart bodyPart : bodyParts) {
                bodyPart.serialize(buffer, separator);
                if (!(bodyPart instanceof MultilineBodyPart)) continue;
                isMultiBody = true;
            }
            if (isMultiBody) {
                MultilineBodyPart.serializeEnd(buffer, separator);
            }
        }
        finally {
            bodyParts.clear();
        }
    }

    Set<TelegramBodyPart> getBodyParts() {
        return this.bodyParts;
    }

    String getBoundary() {
        return this.boundary;
    }

    public static class MultilineBodyPart<T>
    implements TelegramBodyPart {
        private final String contentType;
        private final Map<String, Object> headers = new LinkedHashMap<String, Object>();
        private final T body;
        private final String charset;

        public MultilineBodyPart(String name, T body, String contentType) {
            this(name, body, contentType, StandardCharsets.UTF_8.name());
        }

        public MultilineBodyPart(String name, T body, String contentType, String charset) {
            this.body = body;
            this.contentType = contentType;
            this.charset = charset;
            this.addHeader("name", name);
        }

        public void addHeader(String key, String value) {
            this.headers.put(key, value);
        }

        @Override
        public void serialize(ByteBuffer buffer, String boundary) {
            String partHeader = "--" + boundary + "\r\n";
            buffer.put(partHeader.getBytes());
            Object contentDisposition = "Content-Disposition: form-data; ";
            contentDisposition = (String)contentDisposition + this.headers.entrySet().stream().map(e -> ((String)e.getKey()).toLowerCase() + "=\"" + e.getValue().toString() + "\"").collect(Collectors.joining("; ")) + "\r\n";
            buffer.put(((String)contentDisposition).getBytes());
            String contentTypePart = "Content-Type: " + this.contentType;
            if (this.charset != null) {
                contentTypePart = contentTypePart + "; charset=" + this.charset;
            }
            contentTypePart = contentTypePart + "\r\n\r\n";
            buffer.put(contentTypePart.getBytes());
            if (this.body instanceof String) {
                buffer.put(((String)this.body).getBytes());
            } else if (this.body instanceof byte[]) {
                buffer.put((byte[])this.body);
            }
            buffer.put("\r\n".getBytes());
        }

        public static void serializeEnd(ByteBuffer buffer, String separator) {
            String partHeader = "--" + separator + "--\r\n";
            buffer.put(partHeader.getBytes());
        }
    }

    public static class SingleBodyPart
    implements TelegramBodyPart {
        private final String body;

        public SingleBodyPart(String body) {
            this.body = body;
        }

        @Override
        public void serialize(ByteBuffer buffer, String boundary) {
            buffer.put(this.body.getBytes());
        }
    }

    public static interface TelegramBodyPart {
        public void serialize(ByteBuffer var1, String var2);
    }
}

