/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.util;

import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.model.Update;

public final class TelegramMessageHelper {
    private TelegramMessageHelper() {
    }

    public static void populateExchange(Exchange exchange, Update update) {
        if (update.getMessage() != null) {
            exchange.getMessage().setBody(update.getMessage());
            if (update.getMessage().getChat() != null) {
                exchange.getMessage().setHeader("CamelTelegramChatId", update.getMessage().getChat().getId());
            }
            if (update.getMessage().getDate() != null) {
                exchange.getMessage().setHeader("CamelMessageTimestamp", update.getMessage().getDate().getEpochSecond() * 1000L);
            }
        } else if (update.getChannelPost() != null) {
            exchange.getMessage().setBody(update.getChannelPost());
            if (update.getChannelPost().getChat() != null) {
                exchange.getMessage().setHeader("CamelTelegramChatId", update.getChannelPost().getChat().getId());
            }
            if (update.getChannelPost().getDate() != null) {
                exchange.getMessage().setHeader("CamelMessageTimestamp", update.getChannelPost().getDate().getEpochSecond() * 1000L);
            }
        } else if (update.getCallbackQuery() != null) {
            exchange.getMessage().setBody(update.getCallbackQuery());
        } else if (update.getIncomingInlineQuery() != null) {
            exchange.getMessage().setBody(update.getIncomingInlineQuery());
        }
    }
}

