/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.webhook.WebhookEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Component(value="webhook")
public class WebhookComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private WebhookConfiguration configuration = new WebhookConfiguration();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object delegateUri = remaining;
        if (ObjectHelper.isEmpty((String)delegateUri)) {
            throw new IllegalArgumentException("Wrong uri syntax : webhook:uri, got " + remaining);
        }
        WebhookConfiguration config = this.configuration != null ? this.configuration.copy() : new WebhookConfiguration();
        RestConfiguration restConfig = CamelContextHelper.getRestConfiguration(this.getCamelContext(), config.getWebhookComponentName());
        config.storeConfiguration(restConfig);
        WebhookEndpoint endpoint = new WebhookEndpoint(uri, this, config);
        this.setProperties(endpoint, parameters);
        if (parameters != null && !parameters.isEmpty()) {
            delegateUri = (String)delegateUri + "?" + this.resolveDelegateUriQuery(uri, parameters);
        }
        endpoint.getConfiguration().setEndpointUri((String)delegateUri);
        return endpoint;
    }

    private String resolveDelegateUriQuery(String uri, Map<String, Object> parameters) throws URISyntaxException {
        String query = uri.substring(uri.indexOf(63) + 1);
        Map<String, Object> rawParameters = URISupport.parseQuery(query, true);
        Map<String, Object> filtered = rawParameters.entrySet().stream().filter(e -> parameters.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return URISupport.createQueryString(filtered);
    }

    @Override
    public boolean useRawUri() {
        return true;
    }

    public WebhookConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WebhookConfiguration configuration) {
        this.configuration = configuration;
    }
}

