/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.EventHelper;
import org.apache.camel.util.StopWatch;

class EventNotifierCallback
implements AsyncCallback {
    private final AsyncCallback originalCallback;
    private final StopWatch watch;
    private final Exchange exchange;
    private final Endpoint endpoint;

    public EventNotifierCallback(AsyncCallback originalCallback, Exchange exchange, Endpoint endpoint) {
        this.originalCallback = originalCallback;
        this.exchange = exchange;
        this.endpoint = endpoint;
        boolean sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint);
        this.watch = sending ? new StopWatch() : null;
    }

    @Override
    public void done(boolean doneSync) {
        if (this.watch != null) {
            long timeTaken = this.watch.taken();
            EventHelper.notifyExchangeSent(this.exchange.getContext(), this.exchange, this.endpoint, timeTaken);
        }
        this.originalCallback.done(doneSync);
    }
}

