/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.time.Duration;
import java.util.Date;
import java.util.Timer;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class TimerEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        TimerEndpoint target = (TimerEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(TimerEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "daemon": {
                target.setDaemon(TimerEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delay": {
                target.setDelay(TimerEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(TimerEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(TimerEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "fixedrate": 
            case "fixedRate": {
                target.setFixedRate(TimerEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "includemetadata": 
            case "includeMetadata": {
                target.setIncludeMetadata(TimerEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "pattern": {
                target.setPattern(TimerEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "period": {
                target.setPeriod(TimerEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(TimerEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(TimerEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous(TimerEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "time": {
                target.setTime(TimerEndpointConfigurer.property(camelContext, Date.class, value));
                return true;
            }
            case "timer": {
                target.setTimer(TimerEndpointConfigurer.property(camelContext, Timer.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "daemon": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "fixedrate": 
            case "fixedRate": {
                return Boolean.TYPE;
            }
            case "includemetadata": 
            case "includeMetadata": {
                return Boolean.TYPE;
            }
            case "pattern": {
                return String.class;
            }
            case "period": {
                return Long.TYPE;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "synchronous": {
                return Boolean.TYPE;
            }
            case "time": {
                return Date.class;
            }
            case "timer": {
                return Timer.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        TimerEndpoint target = (TimerEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "daemon": {
                return target.isDaemon();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "fixedrate": 
            case "fixedRate": {
                return target.isFixedRate();
            }
            case "includemetadata": 
            case "includeMetadata": {
                return target.isIncludeMetadata();
            }
            case "pattern": {
                return target.getPattern();
            }
            case "period": {
                return target.getPeriod();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "time": {
                return target.getTime();
            }
            case "timer": {
                return target.getTimer();
            }
        }
        return null;
    }
}

