/*
 * Decompiled with CFR 0.152.
 */
package com.twilio;

import com.twilio.annotations.Preview;
import com.twilio.http.noauth.NoAuthTwilioRestClient;
import java.util.List;

@Preview
public class TwilioNoAuth {
    private static List<String> userAgentExtensions;
    private static String region;
    private static String edge;
    private static volatile NoAuthTwilioRestClient noAuthTwilioRestClient;

    private TwilioNoAuth() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NoAuthTwilioRestClient getRestClient() {
        if (noAuthTwilioRestClient != null) return noAuthTwilioRestClient;
        Class<TwilioNoAuth> clazz = TwilioNoAuth.class;
        synchronized (TwilioNoAuth.class) {
            if (noAuthTwilioRestClient != null) return noAuthTwilioRestClient;
            noAuthTwilioRestClient = TwilioNoAuth.buildOAuthRestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return noAuthTwilioRestClient;
        }
    }

    private static NoAuthTwilioRestClient buildOAuthRestClient() {
        NoAuthTwilioRestClient.Builder builder = new NoAuthTwilioRestClient.Builder();
        if (userAgentExtensions != null) {
            builder.userAgentExtensions(userAgentExtensions);
        }
        builder.region(region);
        builder.edge(edge);
        return builder.build();
    }

    public static List<String> getUserAgentExtensions() {
        return userAgentExtensions;
    }

    static {
        region = System.getenv("TWILIO_REGION");
        edge = System.getenv("TWILIO_EDGE");
    }
}

