/*
 * Decompiled with CFR 0.152.
 */
package com.twilio;

import com.twilio.annotations.Preview;
import com.twilio.exception.AuthenticationException;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.http.bearertoken.OrgsTokenManager;
import com.twilio.http.bearertoken.TokenManager;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Preview
public class TwilioOrgsTokenAuth {
    private static String accessToken;
    private static List<String> userAgentExtensions;
    private static String region;
    private static String edge;
    private static volatile BearerTokenTwilioRestClient restClient;
    private static TokenManager tokenManager;
    private static volatile ExecutorService executorService;

    private TwilioOrgsTokenAuth() {
    }

    public static synchronized void init(String grantType, String clientId, String clientSecret) {
        TwilioOrgsTokenAuth.validateAuthCredentials(grantType, clientId, clientSecret);
        tokenManager = new OrgsTokenManager(grantType, clientId, clientSecret);
    }

    public static synchronized void init(String grantType, String clientId, String clientSecret, String code, String redirectUri, String audience, String refreshToken, String scope) {
        TwilioOrgsTokenAuth.validateAuthCredentials(grantType, clientId, clientSecret);
        tokenManager = new OrgsTokenManager(grantType, clientId, clientSecret, code, redirectUri, audience, refreshToken, scope);
    }

    private static void validateAuthCredentials(String grantType, String clientId, String clientSecret) {
        if (grantType == null) {
            throw new AuthenticationException("Grant Type cannot be null");
        }
        if (clientId == null) {
            throw new AuthenticationException("Client Id cannot be null");
        }
        if (clientSecret == null) {
            throw new AuthenticationException("Client Secret cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BearerTokenTwilioRestClient getRestClient() {
        if (restClient != null) return restClient;
        Class<TwilioOrgsTokenAuth> clazz = TwilioOrgsTokenAuth.class;
        synchronized (TwilioOrgsTokenAuth.class) {
            if (restClient != null) return restClient;
            restClient = TwilioOrgsTokenAuth.buildOAuthRestClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return restClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<TwilioOrgsTokenAuth> clazz = TwilioOrgsTokenAuth.class;
        synchronized (TwilioOrgsTokenAuth.class) {
            if (executorService != null) return executorService;
            executorService = Executors.newCachedThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    private static BearerTokenTwilioRestClient buildOAuthRestClient() {
        BearerTokenTwilioRestClient.Builder builder = new BearerTokenTwilioRestClient.Builder();
        if (userAgentExtensions != null) {
            builder.userAgentExtensions(userAgentExtensions);
        }
        builder.region(region);
        builder.edge(edge);
        if (tokenManager == null) {
            throw new AuthenticationException("Either initialize the authentications class or pass a custom token manager");
        }
        builder.tokenManager(tokenManager);
        return builder.build();
    }

    private static void invalidate() {
        restClient = null;
        tokenManager = null;
    }

    public static List<String> getUserAgentExtensions() {
        return userAgentExtensions;
    }

    public static TokenManager getTokenManager() {
        return tokenManager;
    }

    public static void setTokenManager(TokenManager tokenManager) {
        TwilioOrgsTokenAuth.tokenManager = tokenManager;
    }

    static {
        region = System.getenv("TWILIO_REGION");
        edge = System.getenv("TWILIO_EDGE");
    }
}

