/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.base.bearertoken;

import com.twilio.base.bearertoken.Page;
import com.twilio.base.bearertoken.Reader;
import com.twilio.base.bearertoken.Resource;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResourceSet<E extends Resource>
implements Iterable<E> {
    private final Reader<E> reader;
    private final BearerTokenTwilioRestClient client;
    private boolean autoPaging;
    private long pages = 1L;
    private long pageLimit = Long.MAX_VALUE;
    private long processed = 0L;
    private Page<E> page;
    private Iterator<E> iterator;

    public ResourceSet(Reader<E> reader, BearerTokenTwilioRestClient client, Page<E> page) {
        this.reader = reader;
        this.client = client;
        this.page = page;
        this.iterator = page.getRecords().iterator();
        this.autoPaging = true;
        if (reader.getLimit() != null) {
            this.pageLimit = (long)Math.ceil((double)reader.getLimit().longValue() / (double)page.getPageSize());
        }
    }

    public boolean isAutoPaging() {
        return this.autoPaging;
    }

    public ResourceSet setAutoPaging(boolean autoPaging) {
        this.autoPaging = autoPaging;
        return this;
    }

    public Integer getPageSize() {
        return this.page.getPageSize();
    }

    public ResourceSet<E> setPageSize(int pageSize) {
        this.reader.pageSize(pageSize);
        return this;
    }

    public Long getLimit() {
        return this.reader.getLimit();
    }

    public ResourceSet<E> setLimit(long limit) {
        this.reader.limit(limit);
        return this;
    }

    public long getPageLimit() {
        return this.pageLimit;
    }

    @Override
    public Iterator<E> iterator() {
        return new ResourceSetIterator(this);
    }

    private void fetchNextPage() {
        if (!this.page.hasNextPage() || this.pages >= this.pageLimit) {
            return;
        }
        ++this.pages;
        this.page = this.reader.nextPage(this.page, this.client);
        this.iterator = this.page.getRecords().iterator();
    }

    private class ResourceSetIterator<E extends Resource>
    implements Iterator<E> {
        private final ResourceSet<E> resourceSet;

        public ResourceSetIterator(ResourceSet<E> resourceSet2) {
            this.resourceSet = resourceSet2;
        }

        @Override
        public boolean hasNext() {
            if (this.resourceSet.getLimit() != null && ((ResourceSet)this.resourceSet).processed >= this.resourceSet.getLimit()) {
                return false;
            }
            return ((ResourceSet)this.resourceSet).iterator.hasNext();
        }

        @Override
        public E next() {
            if (this.resourceSet == null || ((ResourceSet)this.resourceSet).iterator == null) {
                throw new NoSuchElementException();
            }
            Resource element = (Resource)((ResourceSet)this.resourceSet).iterator.next();
            if (this.resourceSet.isAutoPaging() && !((ResourceSet)this.resourceSet).iterator.hasNext()) {
                ((ResourceSet)this.resourceSet).fetchNextPage();
            }
            ((ResourceSet)this.resourceSet).processed++;
            return (E)element;
        }

        @Override
        public void remove() {
            if (((ResourceSet)this.resourceSet).iterator != null) {
                ((ResourceSet)this.resourceSet).processed++;
                ((ResourceSet)this.resourceSet).iterator.remove();
            }
        }
    }
}

