/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.http.HttpMethod;
import com.twilio.http.IRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class Request
extends IRequest {
    private static final String DEFAULT_REGION = "us1";
    public static final String QUERY_STRING_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String QUERY_STRING_DATE_FORMAT = "yyyy-MM-dd";
    private String username;
    private String password;

    public Request(HttpMethod method, String url) {
        super(method, url);
    }

    public Request(HttpMethod method, String domain, String uri) {
        this(method, domain, uri, null);
    }

    public Request(HttpMethod method, String domain, String uri, String region) {
        super(method, domain, uri, region);
    }

    public void setAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getAuthString() {
        String credentials = this.username + ":" + this.password;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.US_ASCII));
        return "Basic " + encoded;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean requiresAuthentication() {
        return this.username != null || this.password != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request)o;
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.buildURL(), this.buildURL()) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.queryParams, other.queryParams) && Objects.equals(this.postParams, other.postParams) && Objects.equals(this.headerParams, other.headerParams);
    }
}

