/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.Account;

public class AccountReader
extends Reader<Account> {
    private String friendlyName;
    private Account.Status status;
    private Integer pageSize;

    public AccountReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AccountReader setStatus(Account.Status status) {
        this.status = status;
        return this;
    }

    public AccountReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Account> read(TwilioRestClient client) {
        return new ResourceSet<Account>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Account> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts.json";
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Account> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("accounts", response.getContent(), Account.class, client.getObjectMapper());
    }

    @Override
    public Page<Account> previousPage(Page<Account> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Account> nextPage(Page<Account> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Account> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

