/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.ApplicationCreator;
import com.twilio.rest.api.v2010.account.ApplicationDeleter;
import com.twilio.rest.api.v2010.account.ApplicationFetcher;
import com.twilio.rest.api.v2010.account.ApplicationReader;
import com.twilio.rest.api.v2010.account.ApplicationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Application
extends Resource {
    private static final long serialVersionUID = 38146741905668L;
    private final String accountSid;
    private final String apiVersion;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final URI messageStatusCallback;
    private final String sid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsStatusCallback;
    private final URI smsUrl;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String uri;
    private final Boolean voiceCallerIdLookup;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;
    private final Boolean publicApplicationConnectEnabled;

    public static ApplicationCreator creator() {
        return new ApplicationCreator();
    }

    public static ApplicationCreator creator(String pathAccountSid) {
        return new ApplicationCreator(pathAccountSid);
    }

    public static ApplicationDeleter deleter(String pathSid) {
        return new ApplicationDeleter(pathSid);
    }

    public static ApplicationDeleter deleter(String pathAccountSid, String pathSid) {
        return new ApplicationDeleter(pathAccountSid, pathSid);
    }

    public static ApplicationFetcher fetcher(String pathSid) {
        return new ApplicationFetcher(pathSid);
    }

    public static ApplicationFetcher fetcher(String pathAccountSid, String pathSid) {
        return new ApplicationFetcher(pathAccountSid, pathSid);
    }

    public static ApplicationReader reader() {
        return new ApplicationReader();
    }

    public static ApplicationReader reader(String pathAccountSid) {
        return new ApplicationReader(pathAccountSid);
    }

    public static ApplicationUpdater updater(String pathSid) {
        return new ApplicationUpdater(pathSid);
    }

    public static ApplicationUpdater updater(String pathAccountSid, String pathSid) {
        return new ApplicationUpdater(pathAccountSid, pathSid);
    }

    public static Application fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Application.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Application fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Application.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Application(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="message_status_callback") URI messageStatusCallback, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_status_callback") URI smsStatusCallback, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="uri") String uri, @JsonProperty(value="voice_caller_id_lookup") Boolean voiceCallerIdLookup, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="public_application_connect_enabled") Boolean publicApplicationConnectEnabled) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.messageStatusCallback = messageStatusCallback;
        this.sid = sid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsStatusCallback = smsStatusCallback;
        this.smsUrl = smsUrl;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.uri = uri;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
        this.publicApplicationConnectEnabled = publicApplicationConnectEnabled;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final URI getMessageStatusCallback() {
        return this.messageStatusCallback;
    }

    public final String getSid() {
        return this.sid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsStatusCallback() {
        return this.smsStatusCallback;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final Boolean getPublicApplicationConnectEnabled() {
        return this.publicApplicationConnectEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application other = (Application)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.messageStatusCallback, other.messageStatusCallback) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsStatusCallback, other.smsStatusCallback) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.uri, other.uri) && Objects.equals(this.voiceCallerIdLookup, other.voiceCallerIdLookup) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals(this.publicApplicationConnectEnabled, other.publicApplicationConnectEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.dateCreated, this.dateUpdated, this.friendlyName, this.messageStatusCallback, this.sid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsStatusCallback, this.smsUrl, this.statusCallback, this.statusCallbackMethod, this.uri, this.voiceCallerIdLookup, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceUrl, this.publicApplicationConnectEnabled});
    }

    public String toString() {
        return "Application(accountSid=" + this.getAccountSid() + ", apiVersion=" + this.getApiVersion() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", messageStatusCallback=" + this.getMessageStatusCallback() + ", sid=" + this.getSid() + ", smsFallbackMethod=" + (Object)((Object)this.getSmsFallbackMethod()) + ", smsFallbackUrl=" + this.getSmsFallbackUrl() + ", smsMethod=" + (Object)((Object)this.getSmsMethod()) + ", smsStatusCallback=" + this.getSmsStatusCallback() + ", smsUrl=" + this.getSmsUrl() + ", statusCallback=" + this.getStatusCallback() + ", statusCallbackMethod=" + (Object)((Object)this.getStatusCallbackMethod()) + ", uri=" + this.getUri() + ", voiceCallerIdLookup=" + this.getVoiceCallerIdLookup() + ", voiceFallbackMethod=" + (Object)((Object)this.getVoiceFallbackMethod()) + ", voiceFallbackUrl=" + this.getVoiceFallbackUrl() + ", voiceMethod=" + (Object)((Object)this.getVoiceMethod()) + ", voiceUrl=" + this.getVoiceUrl() + ", publicApplicationConnectEnabled=" + this.getPublicApplicationConnectEnabled() + ")";
    }
}

