/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.type.Endpoint;
import com.twilio.type.Twiml;
import java.net.URI;
import java.util.List;

public class CallCreator
extends Creator<Call> {
    private Endpoint to;
    private Endpoint from;
    private String pathAccountSid;
    private HttpMethod method;
    private URI fallbackUrl;
    private HttpMethod fallbackMethod;
    private URI statusCallback;
    private List<String> statusCallbackEvent;
    private HttpMethod statusCallbackMethod;
    private String sendDigits;
    private Integer timeout;
    private Boolean record;
    private String recordingChannels;
    private String recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private String sipAuthUsername;
    private String sipAuthPassword;
    private String machineDetection;
    private Integer machineDetectionTimeout;
    private List<String> recordingStatusCallbackEvent;
    private String trim;
    private String callerId;
    private Integer machineDetectionSpeechThreshold;
    private Integer machineDetectionSpeechEndThreshold;
    private Integer machineDetectionSilenceTimeout;
    private String asyncAmd;
    private URI asyncAmdStatusCallback;
    private HttpMethod asyncAmdStatusCallbackMethod;
    private String byoc;
    private String callReason;
    private String callToken;
    private String recordingTrack;
    private Integer timeLimit;
    private URI url;
    private Twiml twiml;
    private String applicationSid;

    public CallCreator(Endpoint to, Endpoint from, URI url) {
        this.to = to;
        this.from = from;
        this.url = url;
    }

    public CallCreator(String pathAccountSid, Endpoint to, Endpoint from, URI url) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.url = url;
    }

    public CallCreator(Endpoint to, Endpoint from, Twiml twiml) {
        this.to = to;
        this.from = from;
        this.twiml = twiml;
    }

    public CallCreator(String pathAccountSid, Endpoint to, Endpoint from, Twiml twiml) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.twiml = twiml;
    }

    public CallCreator(Endpoint to, Endpoint from, String applicationSid) {
        this.to = to;
        this.from = from;
        this.applicationSid = applicationSid;
    }

    public CallCreator(String pathAccountSid, Endpoint to, Endpoint from, String applicationSid) {
        this.pathAccountSid = pathAccountSid;
        this.to = to;
        this.from = from;
        this.applicationSid = applicationSid;
    }

    public CallCreator setTo(Endpoint to) {
        this.to = to;
        return this;
    }

    public CallCreator setFrom(Endpoint from) {
        this.from = from;
        return this;
    }

    public CallCreator setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public CallCreator setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public CallCreator setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public CallCreator setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public CallCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public CallCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public CallCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public CallCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public CallCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public CallCreator setSendDigits(String sendDigits) {
        this.sendDigits = sendDigits;
        return this;
    }

    public CallCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public CallCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public CallCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public CallCreator setRecordingStatusCallback(String recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public CallCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public CallCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public CallCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public CallCreator setMachineDetection(String machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    public CallCreator setMachineDetectionTimeout(Integer machineDetectionTimeout) {
        this.machineDetectionTimeout = machineDetectionTimeout;
        return this;
    }

    public CallCreator setRecordingStatusCallbackEvent(List<String> recordingStatusCallbackEvent) {
        this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
        return this;
    }

    public CallCreator setRecordingStatusCallbackEvent(String recordingStatusCallbackEvent) {
        return this.setRecordingStatusCallbackEvent(Promoter.listOfOne(recordingStatusCallbackEvent));
    }

    public CallCreator setTrim(String trim) {
        this.trim = trim;
        return this;
    }

    public CallCreator setCallerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public CallCreator setMachineDetectionSpeechThreshold(Integer machineDetectionSpeechThreshold) {
        this.machineDetectionSpeechThreshold = machineDetectionSpeechThreshold;
        return this;
    }

    public CallCreator setMachineDetectionSpeechEndThreshold(Integer machineDetectionSpeechEndThreshold) {
        this.machineDetectionSpeechEndThreshold = machineDetectionSpeechEndThreshold;
        return this;
    }

    public CallCreator setMachineDetectionSilenceTimeout(Integer machineDetectionSilenceTimeout) {
        this.machineDetectionSilenceTimeout = machineDetectionSilenceTimeout;
        return this;
    }

    public CallCreator setAsyncAmd(String asyncAmd) {
        this.asyncAmd = asyncAmd;
        return this;
    }

    public CallCreator setAsyncAmdStatusCallback(URI asyncAmdStatusCallback) {
        this.asyncAmdStatusCallback = asyncAmdStatusCallback;
        return this;
    }

    public CallCreator setAsyncAmdStatusCallback(String asyncAmdStatusCallback) {
        return this.setAsyncAmdStatusCallback(Promoter.uriFromString(asyncAmdStatusCallback));
    }

    public CallCreator setAsyncAmdStatusCallbackMethod(HttpMethod asyncAmdStatusCallbackMethod) {
        this.asyncAmdStatusCallbackMethod = asyncAmdStatusCallbackMethod;
        return this;
    }

    public CallCreator setByoc(String byoc) {
        this.byoc = byoc;
        return this;
    }

    public CallCreator setCallReason(String callReason) {
        this.callReason = callReason;
        return this;
    }

    public CallCreator setCallToken(String callToken) {
        this.callToken = callToken;
        return this;
    }

    public CallCreator setRecordingTrack(String recordingTrack) {
        this.recordingTrack = recordingTrack;
        return this;
    }

    public CallCreator setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public CallCreator setUrl(URI url) {
        this.url = url;
        return this;
    }

    public CallCreator setUrl(String url) {
        return this.setUrl(Promoter.uriFromString(url));
    }

    public CallCreator setTwiml(Twiml twiml) {
        this.twiml = twiml;
        return this;
    }

    public CallCreator setTwiml(String twiml) {
        return this.setTwiml(Promoter.twimlFromString(twiml));
    }

    public CallCreator setApplicationSid(String applicationSid) {
        this.applicationSid = applicationSid;
        return this;
    }

    @Override
    public Call create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{To}", this.to.toString());
        path = path.replace("{From}", this.from.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Call.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.sendDigits != null) {
            request.addPostParam("SendDigits", this.sendDigits);
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback);
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.machineDetection != null) {
            request.addPostParam("MachineDetection", this.machineDetection);
        }
        if (this.machineDetectionTimeout != null) {
            request.addPostParam("MachineDetectionTimeout", this.machineDetectionTimeout.toString());
        }
        if (this.recordingStatusCallbackEvent != null) {
            for (String prop : this.recordingStatusCallbackEvent) {
                request.addPostParam("RecordingStatusCallbackEvent", prop);
            }
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim);
        }
        if (this.callerId != null) {
            request.addPostParam("CallerId", this.callerId);
        }
        if (this.machineDetectionSpeechThreshold != null) {
            request.addPostParam("MachineDetectionSpeechThreshold", this.machineDetectionSpeechThreshold.toString());
        }
        if (this.machineDetectionSpeechEndThreshold != null) {
            request.addPostParam("MachineDetectionSpeechEndThreshold", this.machineDetectionSpeechEndThreshold.toString());
        }
        if (this.machineDetectionSilenceTimeout != null) {
            request.addPostParam("MachineDetectionSilenceTimeout", this.machineDetectionSilenceTimeout.toString());
        }
        if (this.asyncAmd != null) {
            request.addPostParam("AsyncAmd", this.asyncAmd);
        }
        if (this.asyncAmdStatusCallback != null) {
            request.addPostParam("AsyncAmdStatusCallback", this.asyncAmdStatusCallback.toString());
        }
        if (this.asyncAmdStatusCallbackMethod != null) {
            request.addPostParam("AsyncAmdStatusCallbackMethod", this.asyncAmdStatusCallbackMethod.toString());
        }
        if (this.byoc != null) {
            request.addPostParam("Byoc", this.byoc);
        }
        if (this.callReason != null) {
            request.addPostParam("CallReason", this.callReason);
        }
        if (this.callToken != null) {
            request.addPostParam("CallToken", this.callToken);
        }
        if (this.recordingTrack != null) {
            request.addPostParam("RecordingTrack", this.recordingTrack);
        }
        if (this.timeLimit != null) {
            request.addPostParam("TimeLimit", this.timeLimit.toString());
        }
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.twiml != null) {
            request.addPostParam("Twiml", this.twiml.toString());
        }
        if (this.applicationSid != null) {
            request.addPostParam("ApplicationSid", this.applicationSid);
        }
    }
}

