/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.MessageCreator;
import com.twilio.rest.api.v2010.account.MessageDeleter;
import com.twilio.rest.api.v2010.account.MessageFetcher;
import com.twilio.rest.api.v2010.account.MessageReader;
import com.twilio.rest.api.v2010.account.MessageUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 20600562506098L;
    private final String body;
    private final String numSegments;
    private final Direction direction;
    private final PhoneNumber from;
    private final String to;
    private final ZonedDateTime dateUpdated;
    private final String price;
    private final String errorMessage;
    private final String uri;
    private final String accountSid;
    private final String numMedia;
    private final Status status;
    private final String messagingServiceSid;
    private final String sid;
    private final ZonedDateTime dateSent;
    private final ZonedDateTime dateCreated;
    private final Integer errorCode;
    private final Currency priceUnit;
    private final String apiVersion;
    private final Map<String, String> subresourceUris;

    public static MessageCreator creator(PhoneNumber to, PhoneNumber from, String body) {
        return new MessageCreator(to, from, body);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, PhoneNumber from, String body) {
        return new MessageCreator(pathAccountSid, to, from, body);
    }

    public static MessageCreator creator(PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new MessageCreator(to, from, mediaUrl);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new MessageCreator(pathAccountSid, to, from, mediaUrl);
    }

    public static MessageCreator creator(PhoneNumber to, String messagingServiceSid, String body) {
        return new MessageCreator(to, messagingServiceSid, body);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, String body) {
        return new MessageCreator(pathAccountSid, to, messagingServiceSid, body);
    }

    public static MessageCreator creator(PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        return new MessageCreator(to, messagingServiceSid, mediaUrl);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        return new MessageCreator(pathAccountSid, to, messagingServiceSid, mediaUrl);
    }

    public static MessageDeleter deleter(String pathSid) {
        return new MessageDeleter(pathSid);
    }

    public static MessageDeleter deleter(String pathAccountSid, String pathSid) {
        return new MessageDeleter(pathAccountSid, pathSid);
    }

    public static MessageFetcher fetcher(String pathSid) {
        return new MessageFetcher(pathSid);
    }

    public static MessageFetcher fetcher(String pathAccountSid, String pathSid) {
        return new MessageFetcher(pathAccountSid, pathSid);
    }

    public static MessageReader reader() {
        return new MessageReader();
    }

    public static MessageReader reader(String pathAccountSid) {
        return new MessageReader(pathAccountSid);
    }

    public static MessageUpdater updater(String pathSid) {
        return new MessageUpdater(pathSid);
    }

    public static MessageUpdater updater(String pathAccountSid, String pathSid) {
        return new MessageUpdater(pathAccountSid, pathSid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="body") String body, @JsonProperty(value="num_segments") String numSegments, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="from") PhoneNumber from, @JsonProperty(value="to") String to, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="price") String price, @JsonProperty(value="error_message") String errorMessage, @JsonProperty(value="uri") String uri, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="num_media") String numMedia, @JsonProperty(value="status") Status status, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_sent") String dateSent, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.body = body;
        this.numSegments = numSegments;
        this.direction = direction;
        this.from = from;
        this.to = to;
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.price = price;
        this.errorMessage = errorMessage;
        this.uri = uri;
        this.accountSid = accountSid;
        this.numMedia = numMedia;
        this.status = status;
        this.messagingServiceSid = messagingServiceSid;
        this.sid = sid;
        this.dateSent = DateConverter.rfc2822DateTimeFromString(dateSent);
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.errorCode = errorCode;
        this.priceUnit = priceUnit;
        this.apiVersion = apiVersion;
        this.subresourceUris = subresourceUris;
    }

    public final String getBody() {
        return this.body;
    }

    public final String getNumSegments() {
        return this.numSegments;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final PhoneNumber getFrom() {
        return this.from;
    }

    public final String getTo() {
        return this.to;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getPrice() {
        return this.price;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getNumMedia() {
        return this.numMedia;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateSent() {
        return this.dateSent;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.body, other.body) && Objects.equals(this.numSegments, other.numSegments) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.price, other.price) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.uri, other.uri) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.numMedia, other.numMedia) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateSent, other.dateSent) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.body, this.numSegments, this.direction, this.from, this.to, this.dateUpdated, this.price, this.errorMessage, this.uri, this.accountSid, this.numMedia, this.status, this.messagingServiceSid, this.sid, this.dateSent, this.dateCreated, this.errorCode, this.priceUnit, this.apiVersion, this.subresourceUris});
    }

    public String toString() {
        return "Message(body=" + this.getBody() + ", numSegments=" + this.getNumSegments() + ", direction=" + (Object)((Object)this.getDirection()) + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", dateUpdated=" + this.getDateUpdated() + ", price=" + this.getPrice() + ", errorMessage=" + this.getErrorMessage() + ", uri=" + this.getUri() + ", accountSid=" + this.getAccountSid() + ", numMedia=" + this.getNumMedia() + ", status=" + (Object)((Object)this.getStatus()) + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", sid=" + this.getSid() + ", dateSent=" + this.getDateSent() + ", dateCreated=" + this.getDateCreated() + ", errorCode=" + this.getErrorCode() + ", priceUnit=" + this.getPriceUnit() + ", apiVersion=" + this.getApiVersion() + ", subresourceUris=" + this.getSubresourceUris() + ")";
    }

    public static enum Status {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        DELIVERED("delivered"),
        UNDELIVERED("undelivered"),
        RECEIVING("receiving"),
        RECEIVED("received"),
        ACCEPTED("accepted"),
        SCHEDULED("scheduled"),
        READ("read"),
        PARTIALLY_DELIVERED("partially_delivered"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum UpdateStatus {
        CANCELED("canceled");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum ContentRetention {
        RETAIN("retain"),
        DISCARD("discard");

        private final String value;

        private ContentRetention(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ContentRetention forValue(String value) {
            return (ContentRetention)Promoter.enumFromString((String)value, (Enum[])ContentRetention.values());
        }
    }

    public static enum RiskCheck {
        ENABLE("enable"),
        DISABLE("disable");

        private final String value;

        private RiskCheck(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RiskCheck forValue(String value) {
            return (RiskCheck)Promoter.enumFromString((String)value, (Enum[])RiskCheck.values());
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND_API("outbound-api"),
        OUTBOUND_CALL("outbound-call"),
        OUTBOUND_REPLY("outbound-reply");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            return (Direction)Promoter.enumFromString((String)value, (Enum[])Direction.values());
        }
    }

    public static enum ScheduleType {
        FIXED("fixed");

        private final String value;

        private ScheduleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ScheduleType forValue(String value) {
            return (ScheduleType)Promoter.enumFromString((String)value, (Enum[])ScheduleType.values());
        }
    }

    public static enum AddressRetention {
        RETAIN("retain"),
        OBFUSCATE("obfuscate");

        private final String value;

        private AddressRetention(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRetention forValue(String value) {
            return (AddressRetention)Promoter.enumFromString((String)value, (Enum[])AddressRetention.values());
        }
    }
}

