/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.SiprecCreator;
import com.twilio.rest.api.v2010.account.call.SiprecUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Siprec
extends Resource {
    private static final long serialVersionUID = 230113301753485L;
    private final String sid;
    private final String accountSid;
    private final String callSid;
    private final String name;
    private final Status status;
    private final ZonedDateTime dateUpdated;
    private final String uri;

    public static SiprecCreator creator(String pathCallSid) {
        return new SiprecCreator(pathCallSid);
    }

    public static SiprecCreator creator(String pathAccountSid, String pathCallSid) {
        return new SiprecCreator(pathAccountSid, pathCallSid);
    }

    public static SiprecUpdater updater(String pathCallSid, String pathSid, UpdateStatus status) {
        return new SiprecUpdater(pathCallSid, pathSid, status);
    }

    public static SiprecUpdater updater(String pathAccountSid, String pathCallSid, String pathSid, UpdateStatus status) {
        return new SiprecUpdater(pathAccountSid, pathCallSid, pathSid, status);
    }

    public static Siprec fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Siprec.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Siprec fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Siprec.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Siprec(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="name") String name, @JsonProperty(value="status") Status status, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.name = name;
        this.status = status;
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getName() {
        return this.name;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Siprec other = (Siprec)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.callSid, this.name, this.status, this.dateUpdated, this.uri});
    }

    public String toString() {
        return "Siprec(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", callSid=" + this.getCallSid() + ", name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", dateUpdated=" + this.getDateUpdated() + ", uri=" + this.getUri() + ")";
    }

    public static enum UpdateStatus {
        STOPPED("stopped");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        STOPPED("stopped");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Track {
        INBOUND_TRACK("inbound_track"),
        OUTBOUND_TRACK("outbound_track"),
        BOTH_TRACKS("both_tracks");

        private final String value;

        private Track(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Track forValue(String value) {
            return (Track)Promoter.enumFromString((String)value, (Enum[])Track.values());
        }
    }
}

