/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;

public class ParticipantReader
extends Reader<Participant> {
    private String pathConferenceSid;
    private String pathAccountSid;
    private Boolean muted;
    private Boolean hold;
    private Boolean coaching;
    private Integer pageSize;

    public ParticipantReader(String pathConferenceSid) {
        this.pathConferenceSid = pathConferenceSid;
    }

    public ParticipantReader(String pathAccountSid, String pathConferenceSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
    }

    public ParticipantReader setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantReader setHold(Boolean hold) {
        this.hold = hold;
        return this;
    }

    public ParticipantReader setCoaching(Boolean coaching) {
        this.coaching = coaching;
        return this;
    }

    public ParticipantReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Participant> read(TwilioRestClient client) {
        return new ResourceSet<Participant>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Participant> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Participants.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Participant> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("participants", response.getContent(), Participant.class, client.getObjectMapper());
    }

    @Override
    public Page<Participant> previousPage(Page<Participant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Participant> nextPage(Page<Participant> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Participant> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.muted != null) {
            request.addQueryParam("Muted", this.muted.toString());
        }
        if (this.hold != null) {
            request.addQueryParam("Hold", this.hold.toString());
        }
        if (this.coaching != null) {
            request.addQueryParam("Coaching", this.coaching.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

