/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.message;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.message.Feedback;

public class FeedbackCreator
extends Creator<Feedback> {
    private String pathMessageSid;
    private String pathAccountSid;
    private Feedback.Outcome outcome;

    public FeedbackCreator(String pathMessageSid) {
        this.pathMessageSid = pathMessageSid;
    }

    public FeedbackCreator(String pathAccountSid, String pathMessageSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathMessageSid = pathMessageSid;
    }

    public FeedbackCreator setOutcome(Feedback.Outcome outcome) {
        this.outcome = outcome;
        return this;
    }

    @Override
    public Feedback create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Messages/{MessageSid}/Feedback.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{MessageSid}", this.pathMessageSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Feedback creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Feedback.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.outcome != null) {
            request.addPostParam("Outcome", this.outcome.toString());
        }
    }
}

