/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.queue;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.queue.Member;

public class MemberFetcher
extends Fetcher<Member> {
    private String pathQueueSid;
    private String pathCallSid;
    private String pathAccountSid;

    public MemberFetcher(String pathQueueSid, String pathCallSid) {
        this.pathQueueSid = pathQueueSid;
        this.pathCallSid = pathCallSid;
    }

    public MemberFetcher(String pathAccountSid, String pathQueueSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathQueueSid = pathQueueSid;
        this.pathCallSid = pathCallSid;
    }

    @Override
    public Member fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Queues/{QueueSid}/Members/{CallSid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{QueueSid}", this.pathQueueSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }
}

