/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.recording.AddOnResult;

public class AddOnResultFetcher
extends Fetcher<AddOnResult> {
    private String pathReferenceSid;
    private String pathSid;
    private String pathAccountSid;

    public AddOnResultFetcher(String pathReferenceSid, String pathSid) {
        this.pathReferenceSid = pathReferenceSid;
        this.pathSid = pathSid;
    }

    public AddOnResultFetcher(String pathAccountSid, String pathReferenceSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathReferenceSid = pathReferenceSid;
        this.pathSid = pathSid;
    }

    @Override
    public AddOnResult fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{Sid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ReferenceSid}", this.pathReferenceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddOnResult fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AddOnResult.fromJson(response.getStream(), client.getObjectMapper());
    }
}

