/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording.addonresult.payload;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.recording.addonresult.payload.Data;

public class DataFetcher
extends Fetcher<Data> {
    private String pathReferenceSid;
    private String pathAddOnResultSid;
    private String pathPayloadSid;
    private String pathAccountSid;

    public DataFetcher(String pathReferenceSid, String pathAddOnResultSid, String pathPayloadSid) {
        this.pathReferenceSid = pathReferenceSid;
        this.pathAddOnResultSid = pathAddOnResultSid;
        this.pathPayloadSid = pathPayloadSid;
    }

    public DataFetcher(String pathAccountSid, String pathReferenceSid, String pathAddOnResultSid, String pathPayloadSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathReferenceSid = pathReferenceSid;
        this.pathAddOnResultSid = pathAddOnResultSid;
        this.pathPayloadSid = pathPayloadSid;
    }

    @Override
    public Data fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Recordings/{ReferenceSid}/AddOnResults/{AddOnResultSid}/Payloads/{PayloadSid}/Data.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ReferenceSid}", this.pathReferenceSid.toString());
        path = path.replace("{AddOnResultSid}", this.pathAddOnResultSid.toString());
        path = path.replace("{PayloadSid}", this.pathPayloadSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Data fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Data.fromJson(response.getStream(), client.getObjectMapper());
    }
}

