/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations.AuthRegistrationsCredentialListMappingCreator;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations.AuthRegistrationsCredentialListMappingDeleter;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations.AuthRegistrationsCredentialListMappingFetcher;
import com.twilio.rest.api.v2010.account.sip.domain.authtypes.authtyperegistrations.AuthRegistrationsCredentialListMappingReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthRegistrationsCredentialListMapping
extends Resource {
    private static final long serialVersionUID = 16012497789519L;
    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String sid;

    public static AuthRegistrationsCredentialListMappingCreator creator(String pathDomainSid, String credentialListSid) {
        return new AuthRegistrationsCredentialListMappingCreator(pathDomainSid, credentialListSid);
    }

    public static AuthRegistrationsCredentialListMappingCreator creator(String pathAccountSid, String pathDomainSid, String credentialListSid) {
        return new AuthRegistrationsCredentialListMappingCreator(pathAccountSid, pathDomainSid, credentialListSid);
    }

    public static AuthRegistrationsCredentialListMappingDeleter deleter(String pathDomainSid, String pathSid) {
        return new AuthRegistrationsCredentialListMappingDeleter(pathDomainSid, pathSid);
    }

    public static AuthRegistrationsCredentialListMappingDeleter deleter(String pathAccountSid, String pathDomainSid, String pathSid) {
        return new AuthRegistrationsCredentialListMappingDeleter(pathAccountSid, pathDomainSid, pathSid);
    }

    public static AuthRegistrationsCredentialListMappingFetcher fetcher(String pathDomainSid, String pathSid) {
        return new AuthRegistrationsCredentialListMappingFetcher(pathDomainSid, pathSid);
    }

    public static AuthRegistrationsCredentialListMappingFetcher fetcher(String pathAccountSid, String pathDomainSid, String pathSid) {
        return new AuthRegistrationsCredentialListMappingFetcher(pathAccountSid, pathDomainSid, pathSid);
    }

    public static AuthRegistrationsCredentialListMappingReader reader(String pathDomainSid) {
        return new AuthRegistrationsCredentialListMappingReader(pathDomainSid);
    }

    public static AuthRegistrationsCredentialListMappingReader reader(String pathAccountSid, String pathDomainSid) {
        return new AuthRegistrationsCredentialListMappingReader(pathAccountSid, pathDomainSid);
    }

    public static AuthRegistrationsCredentialListMapping fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AuthRegistrationsCredentialListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AuthRegistrationsCredentialListMapping fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AuthRegistrationsCredentialListMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AuthRegistrationsCredentialListMapping(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthRegistrationsCredentialListMapping other = (AuthRegistrationsCredentialListMapping)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid);
    }

    public String toString() {
        return "AuthRegistrationsCredentialListMapping(accountSid=" + this.getAccountSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", sid=" + this.getSid() + ")";
    }
}

