/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.content.v1.content.ApprovalCreateCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApprovalCreate
extends Resource {
    private static final long serialVersionUID = 150858338844938L;
    private final String name;
    private final String category;
    private final String contentType;
    private final String status;
    private final String rejectionReason;
    private final Boolean allowCategoryChange;

    public static ApprovalCreateCreator creator(String pathContentSid, ContentApprovalRequest contentApprovalRequest) {
        return new ApprovalCreateCreator(pathContentSid, contentApprovalRequest);
    }

    public static ApprovalCreate fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ApprovalCreate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ApprovalCreate fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ApprovalCreate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ApprovalCreate(@JsonProperty(value="name") String name, @JsonProperty(value="category") String category, @JsonProperty(value="content_type") String contentType, @JsonProperty(value="status") String status, @JsonProperty(value="rejection_reason") String rejectionReason, @JsonProperty(value="allow_category_change") Boolean allowCategoryChange) {
        this.name = name;
        this.category = category;
        this.contentType = contentType;
        this.status = status;
        this.rejectionReason = rejectionReason;
        this.allowCategoryChange = allowCategoryChange;
    }

    public final String getName() {
        return this.name;
    }

    public final String getCategory() {
        return this.category;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getRejectionReason() {
        return this.rejectionReason;
    }

    public final Boolean getAllowCategoryChange() {
        return this.allowCategoryChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalCreate other = (ApprovalCreate)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.category, other.category) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.status, other.status) && Objects.equals(this.rejectionReason, other.rejectionReason) && Objects.equals(this.allowCategoryChange, other.allowCategoryChange);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.category, this.contentType, this.status, this.rejectionReason, this.allowCategoryChange);
    }

    public String toString() {
        return "ApprovalCreate(name=" + this.getName() + ", category=" + this.getCategory() + ", contentType=" + this.getContentType() + ", status=" + this.getStatus() + ", rejectionReason=" + this.getRejectionReason() + ", allowCategoryChange=" + this.getAllowCategoryChange() + ")";
    }

    public static class ContentApprovalRequest {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="name")
        private String name;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="category")
        private String category;

        public ContentApprovalRequest(String name, String category) {
            this.name = name;
            this.category = category;
        }

        public static ContentApprovalRequest fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ContentApprovalRequest.class);
        }

        public String toString() {
            return "ApprovalCreate.ContentApprovalRequest(name=" + this.getName() + ", category=" + this.getCategory() + ")";
        }

        public String getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        @JsonProperty(value="category")
        public void setCategory(String category) {
            this.category = category;
        }
    }
}

