/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.content.v2.ContentAndApprovals;
import java.time.ZonedDateTime;
import java.util.List;

public class ContentAndApprovalsReader
extends Reader<ContentAndApprovals> {
    private Integer pageSize;
    private String sortByDate;
    private String sortByContentName;
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private String contentName;
    private String content;
    private List<String> language;
    private List<String> contentType;
    private List<String> channelEligibility;

    public ContentAndApprovalsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public ContentAndApprovalsReader setSortByDate(String sortByDate) {
        this.sortByDate = sortByDate;
        return this;
    }

    public ContentAndApprovalsReader setSortByContentName(String sortByContentName) {
        this.sortByContentName = sortByContentName;
        return this;
    }

    public ContentAndApprovalsReader setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public ContentAndApprovalsReader setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public ContentAndApprovalsReader setContentName(String contentName) {
        this.contentName = contentName;
        return this;
    }

    public ContentAndApprovalsReader setContent(String content) {
        this.content = content;
        return this;
    }

    public ContentAndApprovalsReader setLanguage(List<String> language) {
        this.language = language;
        return this;
    }

    public ContentAndApprovalsReader setLanguage(String language) {
        return this.setLanguage(Promoter.listOfOne(language));
    }

    public ContentAndApprovalsReader setContentType(List<String> contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentAndApprovalsReader setContentType(String contentType) {
        return this.setContentType(Promoter.listOfOne(contentType));
    }

    public ContentAndApprovalsReader setChannelEligibility(List<String> channelEligibility) {
        this.channelEligibility = channelEligibility;
        return this;
    }

    public ContentAndApprovalsReader setChannelEligibility(String channelEligibility) {
        return this.setChannelEligibility(Promoter.listOfOne(channelEligibility));
    }

    @Override
    public ResourceSet<ContentAndApprovals> read(TwilioRestClient client) {
        return new ResourceSet<ContentAndApprovals>(this, client, this.firstPage(client));
    }

    @Override
    public Page<ContentAndApprovals> firstPage(TwilioRestClient client) {
        String path = "/v2/ContentAndApprovals";
        Request request = new Request(HttpMethod.GET, Domains.CONTENT.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<ContentAndApprovals> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ContentAndApprovals read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("contents", response.getContent(), ContentAndApprovals.class, client.getObjectMapper());
    }

    @Override
    public Page<ContentAndApprovals> previousPage(Page<ContentAndApprovals> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONTENT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ContentAndApprovals> nextPage(Page<ContentAndApprovals> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONTENT.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<ContentAndApprovals> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.sortByDate != null) {
            request.addQueryParam("SortByDate", this.sortByDate);
        }
        if (this.sortByContentName != null) {
            request.addQueryParam("SortByContentName", this.sortByContentName);
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toInstant().toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toInstant().toString());
        }
        if (this.contentName != null) {
            request.addQueryParam("ContentName", this.contentName);
        }
        if (this.content != null) {
            request.addQueryParam("Content", this.content);
        }
        if (this.language != null) {
            for (String prop : this.language) {
                request.addQueryParam("Language", prop);
            }
        }
        if (this.contentType != null) {
            for (String prop : this.contentType) {
                request.addQueryParam("ContentType", prop);
            }
        }
        if (this.channelEligibility != null) {
            for (String prop : this.channelEligibility) {
                request.addQueryParam("ChannelEligibility", prop);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

