/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.Message;
import java.time.ZonedDateTime;

public class MessageCreator
extends Creator<Message> {
    private String pathChatServiceSid;
    private String pathConversationSid;
    private Message.WebhookEnabledType xTwilioWebhookEnabled;
    private String author;
    private String body;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateUpdated;
    private String attributes;
    private String mediaSid;
    private String contentSid;
    private String contentVariables;
    private String subject;

    public MessageCreator(String pathChatServiceSid, String pathConversationSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
    }

    public MessageCreator setXTwilioWebhookEnabled(Message.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public MessageCreator setAuthor(String author) {
        this.author = author;
        return this;
    }

    public MessageCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageCreator setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MessageCreator setDateUpdated(ZonedDateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public MessageCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public MessageCreator setMediaSid(String mediaSid) {
        this.mediaSid = mediaSid;
        return this;
    }

    public MessageCreator setContentSid(String contentSid) {
        this.contentSid = contentSid;
        return this;
    }

    public MessageCreator setContentVariables(String contentVariables) {
        this.contentVariables = contentVariables;
        return this;
    }

    public MessageCreator setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public Message create(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{ConversationSid}/Messages";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.author != null) {
            request.addPostParam("Author", this.author);
        }
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toInstant().toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toInstant().toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.mediaSid != null) {
            request.addPostParam("MediaSid", this.mediaSid);
        }
        if (this.contentSid != null) {
            request.addPostParam("ContentSid", this.contentSid);
        }
        if (this.contentVariables != null) {
            request.addPostParam("ContentVariables", this.contentVariables);
        }
        if (this.subject != null) {
            request.addPostParam("Subject", this.subject);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

