/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.Participant;
import java.time.ZonedDateTime;

public class ParticipantCreator
extends Creator<Participant> {
    private String pathChatServiceSid;
    private String pathConversationSid;
    private Participant.WebhookEnabledType xTwilioWebhookEnabled;
    private String identity;
    private String messagingBindingAddress;
    private String messagingBindingProxyAddress;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateUpdated;
    private String attributes;
    private String messagingBindingProjectedAddress;
    private String roleSid;

    public ParticipantCreator(String pathChatServiceSid, String pathConversationSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
    }

    public ParticipantCreator setXTwilioWebhookEnabled(Participant.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public ParticipantCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantCreator setMessagingBindingAddress(String messagingBindingAddress) {
        this.messagingBindingAddress = messagingBindingAddress;
        return this;
    }

    public ParticipantCreator setMessagingBindingProxyAddress(String messagingBindingProxyAddress) {
        this.messagingBindingProxyAddress = messagingBindingProxyAddress;
        return this;
    }

    public ParticipantCreator setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantCreator setDateUpdated(ZonedDateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ParticipantCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ParticipantCreator setMessagingBindingProjectedAddress(String messagingBindingProjectedAddress) {
        this.messagingBindingProjectedAddress = messagingBindingProjectedAddress;
        return this;
    }

    public ParticipantCreator setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{ConversationSid}/Participants";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.messagingBindingAddress != null) {
            request.addPostParam("MessagingBinding.Address", this.messagingBindingAddress);
        }
        if (this.messagingBindingProxyAddress != null) {
            request.addPostParam("MessagingBinding.ProxyAddress", this.messagingBindingProxyAddress);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toInstant().toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toInstant().toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.messagingBindingProjectedAddress != null) {
            request.addPostParam("MessagingBinding.ProjectedAddress", this.messagingBindingProjectedAddress);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

