/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.FlexFlow;
import java.net.URI;

public class FlexFlowCreator
extends Creator<FlexFlow> {
    private String friendlyName;
    private String chatServiceSid;
    private FlexFlow.ChannelType channelType;
    private String contactIdentity;
    private Boolean enabled;
    private FlexFlow.IntegrationType integrationType;
    private String integrationFlowSid;
    private URI integrationUrl;
    private String integrationWorkspaceSid;
    private String integrationWorkflowSid;
    private String integrationChannel;
    private Integer integrationTimeout;
    private Integer integrationPriority;
    private Boolean integrationCreationOnMessage;
    private Boolean longLived;
    private Boolean janitorEnabled;
    private Integer integrationRetryCount;

    public FlexFlowCreator(String friendlyName, String chatServiceSid, FlexFlow.ChannelType channelType) {
        this.friendlyName = friendlyName;
        this.chatServiceSid = chatServiceSid;
        this.channelType = channelType;
    }

    public FlexFlowCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public FlexFlowCreator setChatServiceSid(String chatServiceSid) {
        this.chatServiceSid = chatServiceSid;
        return this;
    }

    public FlexFlowCreator setChannelType(FlexFlow.ChannelType channelType) {
        this.channelType = channelType;
        return this;
    }

    public FlexFlowCreator setContactIdentity(String contactIdentity) {
        this.contactIdentity = contactIdentity;
        return this;
    }

    public FlexFlowCreator setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FlexFlowCreator setIntegrationType(FlexFlow.IntegrationType integrationType) {
        this.integrationType = integrationType;
        return this;
    }

    public FlexFlowCreator setIntegrationFlowSid(String integrationFlowSid) {
        this.integrationFlowSid = integrationFlowSid;
        return this;
    }

    public FlexFlowCreator setIntegrationUrl(URI integrationUrl) {
        this.integrationUrl = integrationUrl;
        return this;
    }

    public FlexFlowCreator setIntegrationUrl(String integrationUrl) {
        return this.setIntegrationUrl(Promoter.uriFromString(integrationUrl));
    }

    public FlexFlowCreator setIntegrationWorkspaceSid(String integrationWorkspaceSid) {
        this.integrationWorkspaceSid = integrationWorkspaceSid;
        return this;
    }

    public FlexFlowCreator setIntegrationWorkflowSid(String integrationWorkflowSid) {
        this.integrationWorkflowSid = integrationWorkflowSid;
        return this;
    }

    public FlexFlowCreator setIntegrationChannel(String integrationChannel) {
        this.integrationChannel = integrationChannel;
        return this;
    }

    public FlexFlowCreator setIntegrationTimeout(Integer integrationTimeout) {
        this.integrationTimeout = integrationTimeout;
        return this;
    }

    public FlexFlowCreator setIntegrationPriority(Integer integrationPriority) {
        this.integrationPriority = integrationPriority;
        return this;
    }

    public FlexFlowCreator setIntegrationCreationOnMessage(Boolean integrationCreationOnMessage) {
        this.integrationCreationOnMessage = integrationCreationOnMessage;
        return this;
    }

    public FlexFlowCreator setLongLived(Boolean longLived) {
        this.longLived = longLived;
        return this;
    }

    public FlexFlowCreator setJanitorEnabled(Boolean janitorEnabled) {
        this.janitorEnabled = janitorEnabled;
        return this;
    }

    public FlexFlowCreator setIntegrationRetryCount(Integer integrationRetryCount) {
        this.integrationRetryCount = integrationRetryCount;
        return this;
    }

    @Override
    public FlexFlow create(TwilioRestClient client) {
        String path = "/v1/FlexFlows";
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{ChatServiceSid}", this.chatServiceSid.toString());
        path = path.replace("{ChannelType}", this.channelType.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlexFlow creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlexFlow.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.chatServiceSid != null) {
            request.addPostParam("ChatServiceSid", this.chatServiceSid);
        }
        if (this.channelType != null) {
            request.addPostParam("ChannelType", this.channelType.toString());
        }
        if (this.contactIdentity != null) {
            request.addPostParam("ContactIdentity", this.contactIdentity);
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.integrationType != null) {
            request.addPostParam("IntegrationType", this.integrationType.toString());
        }
        if (this.integrationFlowSid != null) {
            request.addPostParam("Integration.FlowSid", this.integrationFlowSid);
        }
        if (this.integrationUrl != null) {
            request.addPostParam("Integration.Url", this.integrationUrl.toString());
        }
        if (this.integrationWorkspaceSid != null) {
            request.addPostParam("Integration.WorkspaceSid", this.integrationWorkspaceSid);
        }
        if (this.integrationWorkflowSid != null) {
            request.addPostParam("Integration.WorkflowSid", this.integrationWorkflowSid);
        }
        if (this.integrationChannel != null) {
            request.addPostParam("Integration.Channel", this.integrationChannel);
        }
        if (this.integrationTimeout != null) {
            request.addPostParam("Integration.Timeout", this.integrationTimeout.toString());
        }
        if (this.integrationPriority != null) {
            request.addPostParam("Integration.Priority", this.integrationPriority.toString());
        }
        if (this.integrationCreationOnMessage != null) {
            request.addPostParam("Integration.CreationOnMessage", this.integrationCreationOnMessage.toString());
        }
        if (this.longLived != null) {
            request.addPostParam("LongLived", this.longLived.toString());
        }
        if (this.janitorEnabled != null) {
            request.addPostParam("JanitorEnabled", this.janitorEnabled.toString());
        }
        if (this.integrationRetryCount != null) {
            request.addPostParam("Integration.RetryCount", this.integrationRetryCount.toString());
        }
    }
}

