/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsAssessmentsComment;
import java.math.BigDecimal;

public class InsightsAssessmentsCommentCreator
extends Creator<InsightsAssessmentsComment> {
    private String categoryId;
    private String categoryName;
    private String comment;
    private String segmentId;
    private String agentId;
    private BigDecimal offset;
    private String authorization;

    public InsightsAssessmentsCommentCreator(String categoryId, String categoryName, String comment, String segmentId, String agentId, BigDecimal offset) {
        this.categoryId = categoryId;
        this.categoryName = categoryName;
        this.comment = comment;
        this.segmentId = segmentId;
        this.agentId = agentId;
        this.offset = offset;
    }

    public InsightsAssessmentsCommentCreator setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public InsightsAssessmentsCommentCreator setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    public InsightsAssessmentsCommentCreator setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public InsightsAssessmentsCommentCreator setSegmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public InsightsAssessmentsCommentCreator setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    public InsightsAssessmentsCommentCreator setOffset(BigDecimal offset) {
        this.offset = offset;
        return this;
    }

    public InsightsAssessmentsCommentCreator setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    @Override
    public InsightsAssessmentsComment create(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Assessments/Comments";
        path = path.replace("{CategoryId}", this.categoryId.toString());
        path = path.replace("{CategoryName}", this.categoryName.toString());
        path = path.replace("{Comment}", this.comment.toString());
        path = path.replace("{SegmentId}", this.segmentId.toString());
        path = path.replace("{AgentId}", this.agentId.toString());
        path = path.replace("{Offset}", this.offset.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsAssessmentsComment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InsightsAssessmentsComment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.categoryId != null) {
            request.addPostParam("CategoryId", this.categoryId);
        }
        if (this.categoryName != null) {
            request.addPostParam("CategoryName", this.categoryName);
        }
        if (this.comment != null) {
            request.addPostParam("Comment", this.comment);
        }
        if (this.segmentId != null) {
            request.addPostParam("SegmentId", this.segmentId);
        }
        if (this.agentId != null) {
            request.addPostParam("AgentId", this.agentId);
        }
        if (this.offset != null) {
            request.addPostParam("Offset", this.offset.toString());
        }
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }
}

