/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsQuestionnairesQuestion;
import java.util.List;

public class InsightsQuestionnairesQuestionReader
extends Reader<InsightsQuestionnairesQuestion> {
    private String authorization;
    private List<String> categorySid;
    private Integer pageSize;

    public InsightsQuestionnairesQuestionReader setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public InsightsQuestionnairesQuestionReader setCategorySid(List<String> categorySid) {
        this.categorySid = categorySid;
        return this;
    }

    public InsightsQuestionnairesQuestionReader setCategorySid(String categorySid) {
        return this.setCategorySid(Promoter.listOfOne(categorySid));
    }

    public InsightsQuestionnairesQuestionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<InsightsQuestionnairesQuestion> read(TwilioRestClient client) {
        return new ResourceSet<InsightsQuestionnairesQuestion>(this, client, this.firstPage(client));
    }

    @Override
    public Page<InsightsQuestionnairesQuestion> firstPage(TwilioRestClient client) {
        String path = "/v1/Insights/QualityManagement/Questions";
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<InsightsQuestionnairesQuestion> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsQuestionnairesQuestion read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("questions", response.getContent(), InsightsQuestionnairesQuestion.class, client.getObjectMapper());
    }

    @Override
    public Page<InsightsQuestionnairesQuestion> previousPage(Page<InsightsQuestionnairesQuestion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InsightsQuestionnairesQuestion> nextPage(Page<InsightsQuestionnairesQuestion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InsightsQuestionnairesQuestion> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }

    private void addQueryParams(Request request) {
        if (this.categorySid != null) {
            for (String prop : this.categorySid) {
                request.addQueryParam("CategorySid", prop);
            }
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

