/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.InsightsSegments;
import java.util.List;

public class InsightsSegmentsReader
extends Reader<InsightsSegments> {
    private String authorization;
    private String segmentId;
    private List<String> reservationId;
    private Integer pageSize;

    public InsightsSegmentsReader setAuthorization(String authorization) {
        this.authorization = authorization;
        return this;
    }

    public InsightsSegmentsReader setSegmentId(String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public InsightsSegmentsReader setReservationId(List<String> reservationId) {
        this.reservationId = reservationId;
        return this;
    }

    public InsightsSegmentsReader setReservationId(String reservationId) {
        return this.setReservationId(Promoter.listOfOne(reservationId));
    }

    public InsightsSegmentsReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<InsightsSegments> read(TwilioRestClient client) {
        return new ResourceSet<InsightsSegments>(this, client, this.firstPage(client));
    }

    @Override
    public Page<InsightsSegments> firstPage(TwilioRestClient client) {
        String path = "/v1/Insights/Segments";
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addHeaderParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<InsightsSegments> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InsightsSegments read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("segments", response.getContent(), InsightsSegments.class, client.getObjectMapper());
    }

    @Override
    public Page<InsightsSegments> previousPage(Page<InsightsSegments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InsightsSegments> nextPage(Page<InsightsSegments> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FLEXAPI.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<InsightsSegments> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addHeaderParams(Request request) {
        if (this.authorization != null) {
            request.addHeaderParam("Authorization", this.authorization);
        }
    }

    private void addQueryParams(Request request) {
        if (this.segmentId != null) {
            request.addQueryParam("SegmentId", this.segmentId);
        }
        if (this.reservationId != null) {
            for (String prop : this.reservationId) {
                request.addQueryParam("ReservationId", prop);
            }
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

