/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.InteractionCreator;
import com.twilio.rest.flexapi.v1.InteractionFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Interaction
extends Resource {
    private static final long serialVersionUID = 1684368631913L;
    private final String sid;
    private final Map<String, Object> channel;
    private final Map<String, Object> routing;
    private final URI url;
    private final Map<String, String> links;
    private final String interactionContextSid;

    public static InteractionCreator creator(Map<String, Object> channel) {
        return new InteractionCreator(channel);
    }

    public static InteractionFetcher fetcher(String pathSid) {
        return new InteractionFetcher(pathSid);
    }

    public static Interaction fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Interaction.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Interaction fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Interaction.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Interaction(@JsonProperty(value="sid") String sid, @JsonProperty(value="channel") Map<String, Object> channel, @JsonProperty(value="routing") Map<String, Object> routing, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="interaction_context_sid") String interactionContextSid) {
        this.sid = sid;
        this.channel = channel;
        this.routing = routing;
        this.url = url;
        this.links = links;
        this.interactionContextSid = interactionContextSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, Object> getChannel() {
        return this.channel;
    }

    public final Map<String, Object> getRouting() {
        return this.routing;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getInteractionContextSid() {
        return this.interactionContextSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interaction other = (Interaction)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.channel, other.channel) && Objects.equals(this.routing, other.routing) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.interactionContextSid, other.interactionContextSid);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.channel, this.routing, this.url, this.links, this.interactionContextSid);
    }

    public String toString() {
        return "Interaction(sid=" + this.getSid() + ", channel=" + this.getChannel() + ", routing=" + this.getRouting() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", interactionContextSid=" + this.getInteractionContextSid() + ")";
    }
}

