/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.interaction.interactionchannel.InteractionChannelInvite;
import java.util.Map;

public class InteractionChannelInviteCreator
extends Creator<InteractionChannelInvite> {
    private String pathInteractionSid;
    private String pathChannelSid;
    private Map<String, Object> routing;

    public InteractionChannelInviteCreator(String pathInteractionSid, String pathChannelSid, Map<String, Object> routing) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.routing = routing;
    }

    public InteractionChannelInviteCreator setRouting(Map<String, Object> routing) {
        this.routing = routing;
        return this;
    }

    @Override
    public InteractionChannelInvite create(TwilioRestClient client) {
        String path = "/v1/Interactions/{InteractionSid}/Channels/{ChannelSid}/Invites";
        path = path.replace("{InteractionSid}", this.pathInteractionSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Routing}", this.routing.toString());
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("InteractionChannelInvite creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return InteractionChannelInvite.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.routing != null) {
            request.addPostParam("Routing", Converter.mapToJson(this.routing));
        }
    }
}

