/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1.pluginconfiguration;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.pluginconfiguration.ConfiguredPlugin;

public class ConfiguredPluginFetcher
extends Fetcher<ConfiguredPlugin> {
    private String pathConfigurationSid;
    private String pathPluginSid;
    private String flexMetadata;

    public ConfiguredPluginFetcher(String pathConfigurationSid, String pathPluginSid) {
        this.pathConfigurationSid = pathConfigurationSid;
        this.pathPluginSid = pathPluginSid;
    }

    public ConfiguredPluginFetcher setFlexMetadata(String flexMetadata) {
        this.flexMetadata = flexMetadata;
        return this;
    }

    @Override
    public ConfiguredPlugin fetch(TwilioRestClient client) {
        String path = "/v1/PluginService/Configurations/{ConfigurationSid}/Plugins/{PluginSid}";
        path = path.replace("{ConfigurationSid}", this.pathConfigurationSid.toString());
        path = path.replace("{PluginSid}", this.pathPluginSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConfiguredPlugin fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ConfiguredPlugin.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.flexMetadata != null) {
            request.addHeaderParam("Flex-Metadata", this.flexMetadata);
        }
    }
}

