/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v2;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v2.FlexUser;

public class FlexUserFetcher
extends Fetcher<FlexUser> {
    private String pathInstanceSid;
    private String pathFlexUserSid;

    public FlexUserFetcher(String pathInstanceSid, String pathFlexUserSid) {
        this.pathInstanceSid = pathInstanceSid;
        this.pathFlexUserSid = pathFlexUserSid;
    }

    @Override
    public FlexUser fetch(TwilioRestClient client) {
        String path = "/v2/Instances/{InstanceSid}/Users/{FlexUserSid}";
        path = path.replace("{InstanceSid}", this.pathInstanceSid.toString());
        path = path.replace("{FlexUserSid}", this.pathFlexUserSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.FLEXAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlexUser fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return FlexUser.fromJson(response.getStream(), client.getObjectMapper());
    }
}

