/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.frontlineapi.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.frontlineapi.v1.User;

public class UserUpdater
extends Updater<User> {
    private String pathSid;
    private String friendlyName;
    private String avatar;
    private User.StateType state;
    private Boolean isAvailable;

    public UserUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public UserUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public UserUpdater setAvatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    public UserUpdater setState(User.StateType state) {
        this.state = state;
        return this;
    }

    public UserUpdater setIsAvailable(Boolean isAvailable) {
        this.isAvailable = isAvailable;
        return this;
    }

    @Override
    public User update(TwilioRestClient client) {
        String path = "/v1/Users/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.FRONTLINEAPI.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("User update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.avatar != null) {
            request.addPostParam("Avatar", this.avatar);
        }
        if (this.state != null) {
            request.addPostParam("State", this.state.toString());
        }
        if (this.isAvailable != null) {
            request.addPostParam("IsAvailable", this.isAvailable.toString());
        }
    }
}

