/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.ConferenceFetcher;
import com.twilio.rest.insights.v1.ConferenceReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conference
extends Resource {
    private static final long serialVersionUID = 40059120188961L;
    private final String conferenceSid;
    private final String accountSid;
    private final String friendlyName;
    private final ZonedDateTime createTime;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final Integer durationSeconds;
    private final Integer connectDurationSeconds;
    private final ConferenceStatus status;
    private final Integer maxParticipants;
    private final Integer maxConcurrentParticipants;
    private final Integer uniqueParticipants;
    private final ConferenceEndReason endReason;
    private final String endedBy;
    private final Region mixerRegion;
    private final Region mixerRegionRequested;
    private final Boolean recordingEnabled;
    private final Map<String, Object> detectedIssues;
    private final List<Tag> tags;
    private final Map<String, Object> tagInfo;
    private final ProcessingState processingState;
    private final URI url;
    private final Map<String, String> links;

    public static ConferenceFetcher fetcher(String pathConferenceSid) {
        return new ConferenceFetcher(pathConferenceSid);
    }

    public static ConferenceReader reader() {
        return new ConferenceReader();
    }

    public static Conference fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Conference fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Conference(@JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="create_time") String createTime, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration_seconds") Integer durationSeconds, @JsonProperty(value="connect_duration_seconds") Integer connectDurationSeconds, @JsonProperty(value="status") ConferenceStatus status, @JsonProperty(value="max_participants") Integer maxParticipants, @JsonProperty(value="max_concurrent_participants") Integer maxConcurrentParticipants, @JsonProperty(value="unique_participants") Integer uniqueParticipants, @JsonProperty(value="end_reason") ConferenceEndReason endReason, @JsonProperty(value="ended_by") String endedBy, @JsonProperty(value="mixer_region") Region mixerRegion, @JsonProperty(value="mixer_region_requested") Region mixerRegionRequested, @JsonProperty(value="recording_enabled") Boolean recordingEnabled, @JsonProperty(value="detected_issues") Map<String, Object> detectedIssues, @JsonProperty(value="tags") List<Tag> tags, @JsonProperty(value="tag_info") Map<String, Object> tagInfo, @JsonProperty(value="processing_state") ProcessingState processingState, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.conferenceSid = conferenceSid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.createTime = DateConverter.iso8601DateTimeFromString(createTime);
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.durationSeconds = durationSeconds;
        this.connectDurationSeconds = connectDurationSeconds;
        this.status = status;
        this.maxParticipants = maxParticipants;
        this.maxConcurrentParticipants = maxConcurrentParticipants;
        this.uniqueParticipants = uniqueParticipants;
        this.endReason = endReason;
        this.endedBy = endedBy;
        this.mixerRegion = mixerRegion;
        this.mixerRegionRequested = mixerRegionRequested;
        this.recordingEnabled = recordingEnabled;
        this.detectedIssues = detectedIssues;
        this.tags = tags;
        this.tagInfo = tagInfo;
        this.processingState = processingState;
        this.url = url;
        this.links = links;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public final Integer getConnectDurationSeconds() {
        return this.connectDurationSeconds;
    }

    public final ConferenceStatus getStatus() {
        return this.status;
    }

    public final Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public final Integer getMaxConcurrentParticipants() {
        return this.maxConcurrentParticipants;
    }

    public final Integer getUniqueParticipants() {
        return this.uniqueParticipants;
    }

    public final ConferenceEndReason getEndReason() {
        return this.endReason;
    }

    public final String getEndedBy() {
        return this.endedBy;
    }

    public final Region getMixerRegion() {
        return this.mixerRegion;
    }

    public final Region getMixerRegionRequested() {
        return this.mixerRegionRequested;
    }

    public final Boolean getRecordingEnabled() {
        return this.recordingEnabled;
    }

    public final Map<String, Object> getDetectedIssues() {
        return this.detectedIssues;
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public final Map<String, Object> getTagInfo() {
        return this.tagInfo;
    }

    public final ProcessingState getProcessingState() {
        return this.processingState;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conference other = (Conference)o;
        return Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.durationSeconds, other.durationSeconds) && Objects.equals(this.connectDurationSeconds, other.connectDurationSeconds) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.maxParticipants, other.maxParticipants) && Objects.equals(this.maxConcurrentParticipants, other.maxConcurrentParticipants) && Objects.equals(this.uniqueParticipants, other.uniqueParticipants) && Objects.equals((Object)this.endReason, (Object)other.endReason) && Objects.equals(this.endedBy, other.endedBy) && Objects.equals((Object)this.mixerRegion, (Object)other.mixerRegion) && Objects.equals((Object)this.mixerRegionRequested, (Object)other.mixerRegionRequested) && Objects.equals(this.recordingEnabled, other.recordingEnabled) && Objects.equals(this.detectedIssues, other.detectedIssues) && Objects.equals(this.tags, other.tags) && Objects.equals(this.tagInfo, other.tagInfo) && Objects.equals((Object)this.processingState, (Object)other.processingState) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conferenceSid, this.accountSid, this.friendlyName, this.createTime, this.startTime, this.endTime, this.durationSeconds, this.connectDurationSeconds, this.status, this.maxParticipants, this.maxConcurrentParticipants, this.uniqueParticipants, this.endReason, this.endedBy, this.mixerRegion, this.mixerRegionRequested, this.recordingEnabled, this.detectedIssues, this.tags, this.tagInfo, this.processingState, this.url, this.links});
    }

    public String toString() {
        return "Conference(conferenceSid=" + this.getConferenceSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", createTime=" + this.getCreateTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", durationSeconds=" + this.getDurationSeconds() + ", connectDurationSeconds=" + this.getConnectDurationSeconds() + ", status=" + (Object)((Object)this.getStatus()) + ", maxParticipants=" + this.getMaxParticipants() + ", maxConcurrentParticipants=" + this.getMaxConcurrentParticipants() + ", uniqueParticipants=" + this.getUniqueParticipants() + ", endReason=" + (Object)((Object)this.getEndReason()) + ", endedBy=" + this.getEndedBy() + ", mixerRegion=" + (Object)((Object)this.getMixerRegion()) + ", mixerRegionRequested=" + (Object)((Object)this.getMixerRegionRequested()) + ", recordingEnabled=" + this.getRecordingEnabled() + ", detectedIssues=" + this.getDetectedIssues() + ", tags=" + this.getTags() + ", tagInfo=" + this.getTagInfo() + ", processingState=" + (Object)((Object)this.getProcessingState()) + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum ConferenceStatus {
        IN_PROGRESS("in_progress"),
        NOT_STARTED("not_started"),
        COMPLETED("completed"),
        SUMMARY_TIMEOUT("summary_timeout");

        private final String value;

        private ConferenceStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ConferenceStatus forValue(String value) {
            return (ConferenceStatus)Promoter.enumFromString((String)value, (Enum[])ConferenceStatus.values());
        }
    }

    public static enum ProcessingState {
        COMPLETE("complete"),
        IN_PROGRESS("in_progress"),
        TIMEOUT("timeout");

        private final String value;

        private ProcessingState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ProcessingState forValue(String value) {
            return (ProcessingState)Promoter.enumFromString((String)value, (Enum[])ProcessingState.values());
        }
    }

    public static enum Tag {
        INVALID_REQUESTED_REGION("invalid_requested_region"),
        DUPLICATE_IDENTITY("duplicate_identity"),
        START_FAILURE("start_failure"),
        REGION_CONFIGURATION_ISSUES("region_configuration_issues"),
        QUALITY_WARNINGS("quality_warnings"),
        PARTICIPANT_BEHAVIOR_ISSUES("participant_behavior_issues"),
        HIGH_PACKET_LOSS("high_packet_loss"),
        HIGH_JITTER("high_jitter"),
        HIGH_LATENCY("high_latency"),
        LOW_MOS("low_mos"),
        DETECTED_SILENCE("detected_silence");

        private final String value;

        private Tag(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Tag forValue(String value) {
            return (Tag)Promoter.enumFromString((String)value, (Enum[])Tag.values());
        }
    }

    public static enum Region {
        US1("us1"),
        AU1("au1"),
        BR1("br1"),
        IE1("ie1"),
        JP1("jp1"),
        SG1("sg1"),
        DE1("de1");

        private final String value;

        private Region(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Region forValue(String value) {
            return (Region)Promoter.enumFromString((String)value, (Enum[])Region.values());
        }
    }

    public static enum ConferenceEndReason {
        LAST_PARTICIPANT_LEFT("last_participant_left"),
        CONFERENCE_ENDED_VIA_API("conference_ended_via_api"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_LEFT("participant_with_end_conference_on_exit_left"),
        LAST_PARTICIPANT_KICKED("last_participant_kicked"),
        PARTICIPANT_WITH_END_CONFERENCE_ON_EXIT_KICKED("participant_with_end_conference_on_exit_kicked");

        private final String value;

        private ConferenceEndReason(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ConferenceEndReason forValue(String value) {
            return (ConferenceEndReason)Promoter.enumFromString((String)value, (Enum[])ConferenceEndReason.values());
        }
    }
}

