/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.intelligence.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.intelligence.v2.CustomOperatorCreator;
import com.twilio.rest.intelligence.v2.CustomOperatorDeleter;
import com.twilio.rest.intelligence.v2.CustomOperatorFetcher;
import com.twilio.rest.intelligence.v2.CustomOperatorReader;
import com.twilio.rest.intelligence.v2.CustomOperatorUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomOperator
extends Resource {
    private static final long serialVersionUID = 100488785268469L;
    private final String accountSid;
    private final String sid;
    private final String friendlyName;
    private final String description;
    private final String author;
    private final String operatorType;
    private final Integer version;
    private final Availability availability;
    private final Map<String, Object> config;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static CustomOperatorCreator creator(String friendlyName, String operatorType, Map<String, Object> config) {
        return new CustomOperatorCreator(friendlyName, operatorType, config);
    }

    public static CustomOperatorDeleter deleter(String pathSid) {
        return new CustomOperatorDeleter(pathSid);
    }

    public static CustomOperatorFetcher fetcher(String pathSid) {
        return new CustomOperatorFetcher(pathSid);
    }

    public static CustomOperatorReader reader() {
        return new CustomOperatorReader();
    }

    public static CustomOperatorUpdater updater(String pathSid, String friendlyName, Map<String, Object> config) {
        return new CustomOperatorUpdater(pathSid, friendlyName, config);
    }

    public static CustomOperator fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomOperator.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CustomOperator fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CustomOperator.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CustomOperator(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="author") String author, @JsonProperty(value="operator_type") String operatorType, @JsonProperty(value="version") Integer version, @JsonProperty(value="availability") Availability availability, @JsonProperty(value="config") Map<String, Object> config, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.author = author;
        this.operatorType = operatorType;
        this.version = version;
        this.availability = availability;
        this.config = config;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getOperatorType() {
        return this.operatorType;
    }

    public final Integer getVersion() {
        return this.version;
    }

    public final Availability getAvailability() {
        return this.availability;
    }

    public final Map<String, Object> getConfig() {
        return this.config;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomOperator other = (CustomOperator)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.author, other.author) && Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.availability, (Object)other.availability) && Objects.equals(this.config, other.config) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.sid, this.friendlyName, this.description, this.author, this.operatorType, this.version, this.availability, this.config, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "CustomOperator(accountSid=" + this.getAccountSid() + ", sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", author=" + this.getAuthor() + ", operatorType=" + this.getOperatorType() + ", version=" + this.getVersion() + ", availability=" + (Object)((Object)this.getAvailability()) + ", config=" + this.getConfig() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Availability {
        INTERNAL("internal"),
        BETA("beta"),
        PUBLIC("public"),
        RETIRED("retired");

        private final String value;

        private Availability(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Availability forValue(String value) {
            return (Availability)Promoter.enumFromString((String)value, (Enum[])Availability.values());
        }
    }
}

